/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.domsnapshot.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.dom.model.Rect;
import org.openqa.selenium.devtools.domsnapshot.model.InlineTextBox;
import org.openqa.selenium.json.JsonInput;

public class LayoutTreeNode {
    private final Integer domNodeIndex;
    private final Rect boundingBox;
    private final String layoutText;
    private final List<InlineTextBox> inlineTextNodes;
    private final Integer styleIndex;
    private final Integer paintOrder;
    private final Boolean isStackingContext;

    public LayoutTreeNode(Integer domNodeIndex, Rect boundingBox, String layoutText, List<InlineTextBox> inlineTextNodes, Integer styleIndex, Integer paintOrder, Boolean isStackingContext) {
        this.domNodeIndex = Objects.requireNonNull(domNodeIndex, "domNodeIndex is required");
        this.boundingBox = Objects.requireNonNull(boundingBox, "boundingBox is required");
        this.layoutText = layoutText;
        this.inlineTextNodes = inlineTextNodes;
        this.styleIndex = styleIndex;
        this.paintOrder = paintOrder;
        this.isStackingContext = isStackingContext;
    }

    public Integer getDomNodeIndex() {
        return this.domNodeIndex;
    }

    public Rect getBoundingBox() {
        return this.boundingBox;
    }

    public String getLayoutText() {
        return this.layoutText;
    }

    public List<InlineTextBox> getInlineTextNodes() {
        return this.inlineTextNodes;
    }

    public Integer getStyleIndex() {
        return this.styleIndex;
    }

    public Integer getPaintOrder() {
        return this.paintOrder;
    }

    public Boolean getIsStackingContext() {
        return this.isStackingContext;
    }

    private static LayoutTreeNode fromJson(JsonInput input) {
        Integer domNodeIndex = null;
        Rect boundingBox = null;
        String layoutText = null;
        List inlineTextNodes = null;
        Integer styleIndex = null;
        Integer paintOrder = null;
        Boolean isStackingContext = null;
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "domNodeIndex": {
                    domNodeIndex = input.nextNumber().intValue();
                    continue block18;
                }
                case "boundingBox": {
                    boundingBox = (Rect)input.read(Rect.class);
                    continue block18;
                }
                case "layoutText": {
                    layoutText = input.nextString();
                    continue block18;
                }
                case "inlineTextNodes": {
                    inlineTextNodes = (List)input.read(new TypeToken<List<InlineTextBox>>(){}.getType());
                    continue block18;
                }
                case "styleIndex": {
                    styleIndex = input.nextNumber().intValue();
                    continue block18;
                }
                case "paintOrder": {
                    paintOrder = input.nextNumber().intValue();
                    continue block18;
                }
                case "isStackingContext": {
                    isStackingContext = input.nextBoolean();
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new LayoutTreeNode(domNodeIndex, boundingBox, layoutText, inlineTextNodes, styleIndex, paintOrder, isStackingContext);
    }
}

