/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.domsnapshot.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.domsnapshot.model.ArrayOfStrings;
import org.openqa.selenium.devtools.domsnapshot.model.RareBooleanData;
import org.openqa.selenium.devtools.domsnapshot.model.Rectangle;
import org.openqa.selenium.devtools.domsnapshot.model.StringIndex;
import org.openqa.selenium.json.JsonInput;

public class LayoutTreeSnapshot {
    private final List<Integer> nodeIndex;
    private final List<ArrayOfStrings> styles;
    private final List<Rectangle> bounds;
    private final List<StringIndex> text;
    private final RareBooleanData stackingContexts;
    private final List<Integer> paintOrders;
    private final List<Rectangle> offsetRects;
    private final List<Rectangle> scrollRects;
    private final List<Rectangle> clientRects;

    public LayoutTreeSnapshot(List<Integer> nodeIndex, List<ArrayOfStrings> styles, List<Rectangle> bounds, List<StringIndex> text, RareBooleanData stackingContexts, List<Integer> paintOrders, List<Rectangle> offsetRects, List<Rectangle> scrollRects, List<Rectangle> clientRects) {
        this.nodeIndex = Objects.requireNonNull(nodeIndex, "nodeIndex is required");
        this.styles = Objects.requireNonNull(styles, "styles is required");
        this.bounds = Objects.requireNonNull(bounds, "bounds is required");
        this.text = Objects.requireNonNull(text, "text is required");
        this.stackingContexts = Objects.requireNonNull(stackingContexts, "stackingContexts is required");
        this.paintOrders = paintOrders;
        this.offsetRects = offsetRects;
        this.scrollRects = scrollRects;
        this.clientRects = clientRects;
    }

    public List<Integer> getNodeIndex() {
        return this.nodeIndex;
    }

    public List<ArrayOfStrings> getStyles() {
        return this.styles;
    }

    public List<Rectangle> getBounds() {
        return this.bounds;
    }

    public List<StringIndex> getText() {
        return this.text;
    }

    public RareBooleanData getStackingContexts() {
        return this.stackingContexts;
    }

    public List<Integer> getPaintOrders() {
        return this.paintOrders;
    }

    public List<Rectangle> getOffsetRects() {
        return this.offsetRects;
    }

    public List<Rectangle> getScrollRects() {
        return this.scrollRects;
    }

    public List<Rectangle> getClientRects() {
        return this.clientRects;
    }

    private static LayoutTreeSnapshot fromJson(JsonInput input) {
        List nodeIndex = null;
        List styles = null;
        List bounds = null;
        List text = null;
        RareBooleanData stackingContexts = null;
        List paintOrders = null;
        List offsetRects = null;
        List scrollRects = null;
        List clientRects = null;
        input.beginObject();
        block22: while (input.hasNext()) {
            switch (input.nextName()) {
                case "nodeIndex": {
                    nodeIndex = (List)input.read(new TypeToken<List<Integer>>(){}.getType());
                    continue block22;
                }
                case "styles": {
                    styles = (List)input.read(new TypeToken<List<ArrayOfStrings>>(){}.getType());
                    continue block22;
                }
                case "bounds": {
                    bounds = (List)input.read(new TypeToken<List<Rectangle>>(){}.getType());
                    continue block22;
                }
                case "text": {
                    text = (List)input.read(new TypeToken<List<StringIndex>>(){}.getType());
                    continue block22;
                }
                case "stackingContexts": {
                    stackingContexts = (RareBooleanData)input.read(RareBooleanData.class);
                    continue block22;
                }
                case "paintOrders": {
                    paintOrders = (List)input.read(new TypeToken<List<Integer>>(){}.getType());
                    continue block22;
                }
                case "offsetRects": {
                    offsetRects = (List)input.read(new TypeToken<List<Rectangle>>(){}.getType());
                    continue block22;
                }
                case "scrollRects": {
                    scrollRects = (List)input.read(new TypeToken<List<Rectangle>>(){}.getType());
                    continue block22;
                }
                case "clientRects": {
                    clientRects = (List)input.read(new TypeToken<List<Rectangle>>(){}.getType());
                    continue block22;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new LayoutTreeSnapshot(nodeIndex, styles, bounds, text, stackingContexts, paintOrders, offsetRects, scrollRects, clientRects);
    }
}

