/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.input.model;

import java.util.Objects;
import org.openqa.selenium.json.JsonInput;

public class TouchPoint {
    private final Number x;
    private final Number y;
    private final Number radiusX;
    private final Number radiusY;
    private final Number rotationAngle;
    private final Number force;
    private final Number id;

    public TouchPoint(Number x, Number y, Number radiusX, Number radiusY, Number rotationAngle, Number force, Number id) {
        this.x = Objects.requireNonNull(x, "x is required");
        this.y = Objects.requireNonNull(y, "y is required");
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.rotationAngle = rotationAngle;
        this.force = force;
        this.id = id;
    }

    public Number getX() {
        return this.x;
    }

    public Number getY() {
        return this.y;
    }

    public Number getRadiusX() {
        return this.radiusX;
    }

    public Number getRadiusY() {
        return this.radiusY;
    }

    public Number getRotationAngle() {
        return this.rotationAngle;
    }

    public Number getForce() {
        return this.force;
    }

    public Number getId() {
        return this.id;
    }

    private static TouchPoint fromJson(JsonInput input) {
        Number x = null;
        Number y = null;
        Number radiusX = null;
        Number radiusY = null;
        Number rotationAngle = null;
        Number force = null;
        Number id = null;
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "x": {
                    x = input.nextNumber();
                    continue block18;
                }
                case "y": {
                    y = input.nextNumber();
                    continue block18;
                }
                case "radiusX": {
                    radiusX = input.nextNumber();
                    continue block18;
                }
                case "radiusY": {
                    radiusY = input.nextNumber();
                    continue block18;
                }
                case "rotationAngle": {
                    rotationAngle = input.nextNumber();
                    continue block18;
                }
                case "force": {
                    force = input.nextNumber();
                    continue block18;
                }
                case "id": {
                    id = input.nextNumber();
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new TouchPoint(x, y, radiusX, radiusY, rotationAngle, force, id);
    }
}

