/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.memory;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.memory.model.PressureLevel;
import org.openqa.selenium.devtools.memory.model.SamplingProfile;
import org.openqa.selenium.json.JsonInput;

@Beta
public class Memory {
    public static Command<GetDOMCountersResponse> getDOMCounters() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<GetDOMCountersResponse>("Memory.getDOMCounters", (Map<String, Object>)params.build(), input -> (GetDOMCountersResponse)input.read(GetDOMCountersResponse.class));
    }

    public static Command<Void> prepareForLeakDetection() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Memory.prepareForLeakDetection", (Map<String, Object>)params.build());
    }

    public static Command<Void> forciblyPurgeJavaScriptMemory() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Memory.forciblyPurgeJavaScriptMemory", (Map<String, Object>)params.build());
    }

    public static Command<Void> setPressureNotificationsSuppressed(Boolean suppressed) {
        Objects.requireNonNull(suppressed, "suppressed is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"suppressed", (Object)suppressed);
        return new Command<Void>("Memory.setPressureNotificationsSuppressed", (Map<String, Object>)params.build());
    }

    public static Command<Void> simulatePressureNotification(PressureLevel level) {
        Objects.requireNonNull(level, "level is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"level", (Object)level);
        return new Command<Void>("Memory.simulatePressureNotification", (Map<String, Object>)params.build());
    }

    public static Command<Void> startSampling(Optional<Integer> samplingInterval, Optional<Boolean> suppressRandomness) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        samplingInterval.ifPresent(p -> params.put((Object)"samplingInterval", p));
        suppressRandomness.ifPresent(p -> params.put((Object)"suppressRandomness", p));
        return new Command<Void>("Memory.startSampling", (Map<String, Object>)params.build());
    }

    public static Command<Void> stopSampling() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Memory.stopSampling", (Map<String, Object>)params.build());
    }

    public static Command<SamplingProfile> getAllTimeSamplingProfile() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<SamplingProfile>("Memory.getAllTimeSamplingProfile", (Map<String, Object>)params.build(), ConverterFunctions.map("profile", SamplingProfile.class));
    }

    public static Command<SamplingProfile> getBrowserSamplingProfile() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<SamplingProfile>("Memory.getBrowserSamplingProfile", (Map<String, Object>)params.build(), ConverterFunctions.map("profile", SamplingProfile.class));
    }

    public static Command<SamplingProfile> getSamplingProfile() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<SamplingProfile>("Memory.getSamplingProfile", (Map<String, Object>)params.build(), ConverterFunctions.map("profile", SamplingProfile.class));
    }

    public static class GetDOMCountersResponse {
        private final Integer documents;
        private final Integer nodes;
        private final Integer jsEventListeners;

        public GetDOMCountersResponse(Integer documents, Integer nodes, Integer jsEventListeners) {
            this.documents = Objects.requireNonNull(documents, "documents is required");
            this.nodes = Objects.requireNonNull(nodes, "nodes is required");
            this.jsEventListeners = Objects.requireNonNull(jsEventListeners, "jsEventListeners is required");
        }

        public Integer getDocuments() {
            return this.documents;
        }

        public Integer getNodes() {
            return this.nodes;
        }

        public Integer getJsEventListeners() {
            return this.jsEventListeners;
        }

        private static GetDOMCountersResponse fromJson(JsonInput input) {
            Integer documents = null;
            Integer nodes = null;
            Integer jsEventListeners = null;
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "documents": {
                        documents = input.nextNumber().intValue();
                        continue block10;
                    }
                    case "nodes": {
                        nodes = input.nextNumber().intValue();
                        continue block10;
                    }
                    case "jsEventListeners": {
                        jsEventListeners = input.nextNumber().intValue();
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetDOMCountersResponse(documents, nodes, jsEventListeners);
        }
    }
}

