/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.network.model.InterceptionStage;
import org.openqa.selenium.devtools.network.model.ResourceType;
import org.openqa.selenium.json.JsonInput;

@Beta
public class RequestPattern {
    private final String urlPattern;
    private final ResourceType resourceType;
    private final InterceptionStage interceptionStage;

    public RequestPattern(String urlPattern, ResourceType resourceType, InterceptionStage interceptionStage) {
        this.urlPattern = urlPattern;
        this.resourceType = resourceType;
        this.interceptionStage = interceptionStage;
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public InterceptionStage getInterceptionStage() {
        return this.interceptionStage;
    }

    private static RequestPattern fromJson(JsonInput input) {
        String urlPattern = null;
        ResourceType resourceType = null;
        InterceptionStage interceptionStage = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "urlPattern": {
                    urlPattern = input.nextString();
                    continue block10;
                }
                case "resourceType": {
                    resourceType = (ResourceType)((Object)input.read(ResourceType.class));
                    continue block10;
                }
                case "interceptionStage": {
                    interceptionStage = (InterceptionStage)((Object)input.read(InterceptionStage.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RequestPattern(urlPattern, resourceType, interceptionStage);
    }
}

