/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.page.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.network.model.LoaderId;
import org.openqa.selenium.devtools.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class Frame {
    private final FrameId id;
    private final String parentId;
    private final LoaderId loaderId;
    private final String name;
    private final String url;
    private final String urlFragment;
    private final String securityOrigin;
    private final String mimeType;
    private final String unreachableUrl;

    public Frame(FrameId id, String parentId, LoaderId loaderId, String name, String url, String urlFragment, String securityOrigin, String mimeType, String unreachableUrl) {
        this.id = Objects.requireNonNull(id, "id is required");
        this.parentId = parentId;
        this.loaderId = Objects.requireNonNull(loaderId, "loaderId is required");
        this.name = name;
        this.url = Objects.requireNonNull(url, "url is required");
        this.urlFragment = urlFragment;
        this.securityOrigin = Objects.requireNonNull(securityOrigin, "securityOrigin is required");
        this.mimeType = Objects.requireNonNull(mimeType, "mimeType is required");
        this.unreachableUrl = unreachableUrl;
    }

    public FrameId getId() {
        return this.id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public LoaderId getLoaderId() {
        return this.loaderId;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    @Beta
    public String getUrlFragment() {
        return this.urlFragment;
    }

    public String getSecurityOrigin() {
        return this.securityOrigin;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    @Beta
    public String getUnreachableUrl() {
        return this.unreachableUrl;
    }

    private static Frame fromJson(JsonInput input) {
        FrameId id = null;
        String parentId = null;
        LoaderId loaderId = null;
        String name = null;
        String url = null;
        String urlFragment = null;
        String securityOrigin = null;
        String mimeType = null;
        String unreachableUrl = null;
        input.beginObject();
        block22: while (input.hasNext()) {
            switch (input.nextName()) {
                case "id": {
                    id = (FrameId)input.read(FrameId.class);
                    continue block22;
                }
                case "parentId": {
                    parentId = input.nextString();
                    continue block22;
                }
                case "loaderId": {
                    loaderId = (LoaderId)input.read(LoaderId.class);
                    continue block22;
                }
                case "name": {
                    name = input.nextString();
                    continue block22;
                }
                case "url": {
                    url = input.nextString();
                    continue block22;
                }
                case "urlFragment": {
                    urlFragment = input.nextString();
                    continue block22;
                }
                case "securityOrigin": {
                    securityOrigin = input.nextString();
                    continue block22;
                }
                case "mimeType": {
                    mimeType = input.nextString();
                    continue block22;
                }
                case "unreachableUrl": {
                    unreachableUrl = input.nextString();
                    continue block22;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Frame(id, parentId, loaderId, name, url, urlFragment, securityOrigin, mimeType, unreachableUrl);
    }
}

