/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.page.model;

import java.util.Arrays;
import java.util.Objects;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

@Deprecated
public class FrameScheduledNavigation {
    private final FrameId frameId;
    private final Number delay;
    private final Reason reason;
    private final String url;

    public FrameScheduledNavigation(FrameId frameId, Number delay, Reason reason, String url) {
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.delay = Objects.requireNonNull(delay, "delay is required");
        this.reason = Objects.requireNonNull(reason, "reason is required");
        this.url = Objects.requireNonNull(url, "url is required");
    }

    public FrameId getFrameId() {
        return this.frameId;
    }

    public Number getDelay() {
        return this.delay;
    }

    public Reason getReason() {
        return this.reason;
    }

    public String getUrl() {
        return this.url;
    }

    private static FrameScheduledNavigation fromJson(JsonInput input) {
        FrameId frameId = null;
        Number delay = null;
        Reason reason = null;
        String url = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "frameId": {
                    frameId = (FrameId)input.read(FrameId.class);
                    continue block12;
                }
                case "delay": {
                    delay = input.nextNumber();
                    continue block12;
                }
                case "reason": {
                    reason = Reason.fromString(input.nextString());
                    continue block12;
                }
                case "url": {
                    url = input.nextString();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new FrameScheduledNavigation(frameId, delay, reason, url);
    }

    public static enum Reason {
        FORMSUBMISSIONGET("formSubmissionGet"),
        FORMSUBMISSIONPOST("formSubmissionPost"),
        HTTPHEADERREFRESH("httpHeaderRefresh"),
        SCRIPTINITIATED("scriptInitiated"),
        METATAGREFRESH("metaTagRefresh"),
        PAGEBLOCKINTERSTITIAL("pageBlockInterstitial"),
        RELOAD("reload");

        private String value;

        private Reason(String value) {
            this.value = value;
        }

        public static Reason fromString(String s) {
            return Arrays.stream(Reason.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Reason "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Reason fromJson(JsonInput input) {
            return Reason.fromString(input.nextString());
        }
    }
}

