/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.webaudio.model;

import java.util.Objects;
import org.openqa.selenium.devtools.webaudio.model.GraphObjectId;
import org.openqa.selenium.json.JsonInput;

public class NodesDisconnected {
    private final GraphObjectId contextId;
    private final GraphObjectId sourceId;
    private final GraphObjectId destinationId;
    private final Number sourceOutputIndex;
    private final Number destinationInputIndex;

    public NodesDisconnected(GraphObjectId contextId, GraphObjectId sourceId, GraphObjectId destinationId, Number sourceOutputIndex, Number destinationInputIndex) {
        this.contextId = Objects.requireNonNull(contextId, "contextId is required");
        this.sourceId = Objects.requireNonNull(sourceId, "sourceId is required");
        this.destinationId = Objects.requireNonNull(destinationId, "destinationId is required");
        this.sourceOutputIndex = sourceOutputIndex;
        this.destinationInputIndex = destinationInputIndex;
    }

    public GraphObjectId getContextId() {
        return this.contextId;
    }

    public GraphObjectId getSourceId() {
        return this.sourceId;
    }

    public GraphObjectId getDestinationId() {
        return this.destinationId;
    }

    public Number getSourceOutputIndex() {
        return this.sourceOutputIndex;
    }

    public Number getDestinationInputIndex() {
        return this.destinationInputIndex;
    }

    private static NodesDisconnected fromJson(JsonInput input) {
        GraphObjectId contextId = null;
        GraphObjectId sourceId = null;
        GraphObjectId destinationId = null;
        Number sourceOutputIndex = null;
        Number destinationInputIndex = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "contextId": {
                    contextId = (GraphObjectId)input.read(GraphObjectId.class);
                    continue block14;
                }
                case "sourceId": {
                    sourceId = (GraphObjectId)input.read(GraphObjectId.class);
                    continue block14;
                }
                case "destinationId": {
                    destinationId = (GraphObjectId)input.read(GraphObjectId.class);
                    continue block14;
                }
                case "sourceOutputIndex": {
                    sourceOutputIndex = input.nextNumber();
                    continue block14;
                }
                case "destinationInputIndex": {
                    destinationInputIndex = input.nextNumber();
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new NodesDisconnected(contextId, sourceId, destinationId, sourceOutputIndex, destinationInputIndex);
    }
}

