/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.lang.Nullable;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.result.method.InvocableHandlerMethod;
import org.springframework.web.reactive.result.method.SyncHandlerMethodArgumentResolver;
import org.springframework.web.server.ServerErrorException;
import org.springframework.web.server.ServerWebExchange;

public class SyncInvocableHandlerMethod
extends HandlerMethod {
    private final InvocableHandlerMethod delegate;

    public SyncInvocableHandlerMethod(HandlerMethod handlerMethod) {
        super(handlerMethod);
        this.delegate = new InvocableHandlerMethod(handlerMethod);
    }

    public SyncInvocableHandlerMethod(Object bean, Method method) {
        super(bean, method);
        this.delegate = new InvocableHandlerMethod(bean, method);
    }

    public void setArgumentResolvers(List<SyncHandlerMethodArgumentResolver> resolvers) {
        this.delegate.setArgumentResolvers(resolvers);
    }

    public List<SyncHandlerMethodArgumentResolver> getResolvers() {
        return this.delegate.getResolvers().stream().map(resolver -> (SyncHandlerMethodArgumentResolver)resolver).toList();
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer nameDiscoverer) {
        this.delegate.setParameterNameDiscoverer(nameDiscoverer);
    }

    public ParameterNameDiscoverer getParameterNameDiscoverer() {
        return this.delegate.getParameterNameDiscoverer();
    }

    @Nullable
    public HandlerResult invokeForHandlerResult(ServerWebExchange exchange, BindingContext bindingContext, Object ... providedArgs) {
        Throwable failure;
        CompletableFuture future = this.delegate.invoke(exchange, bindingContext, providedArgs).toFuture();
        if (!future.isDone()) {
            throw new IllegalStateException("SyncInvocableHandlerMethod should have completed synchronously.");
        }
        try {
            return (HandlerResult)future.get();
        }
        catch (ExecutionException ex) {
            failure = ex.getCause();
        }
        catch (InterruptedException ex) {
            failure = ex;
        }
        throw new ServerErrorException("Failed to invoke: " + this.getShortLogMessage(), this.getMethod(), failure);
    }
}

