/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.adapter;

import java.util.List;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.WebSocketSession;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public final class ContextWebSocketHandler
implements WebSocketHandler {
    private final WebSocketHandler delegate;
    private final ContextView contextView;

    private ContextWebSocketHandler(WebSocketHandler delegate, ContextView contextView) {
        this.delegate = delegate;
        this.contextView = contextView;
    }

    @Override
    public List<String> getSubProtocols() {
        return this.delegate.getSubProtocols();
    }

    @Override
    public Mono<Void> handle(WebSocketSession session) {
        return this.delegate.handle(session).contextWrite(this.contextView);
    }

    public static WebSocketHandler decorate(WebSocketHandler handler, ContextView contextView) {
        return !contextView.isEmpty() ? new ContextWebSocketHandler(handler, contextView) : handler;
    }
}

