/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi;

import java.lang.reflect.ParameterizedType;
import org.web3j.abi.datatypes.Type;

public abstract class TypeReference<T extends Type>
implements Comparable<TypeReference<T>> {
    private final java.lang.reflect.Type type;

    protected TypeReference() {
        java.lang.reflect.Type superclass = this.getClass().getGenericSuperclass();
        if (superclass instanceof Class) {
            throw new RuntimeException("Missing type parameter.");
        }
        this.type = ((ParameterizedType)superclass).getActualTypeArguments()[0];
    }

    @Override
    public int compareTo(TypeReference<T> o) {
        return 0;
    }

    public java.lang.reflect.Type getType() {
        return this.type;
    }

    public Class<T> getClassType() throws ClassNotFoundException {
        java.lang.reflect.Type clsType = this.getType();
        if (this.getType() instanceof ParameterizedType) {
            return (Class)((ParameterizedType)clsType).getRawType();
        }
        return Class.forName(clsType.getTypeName());
    }

    public static <T extends Type> TypeReference<T> create(final Class<T> cls) {
        return new TypeReference<T>(){

            @Override
            public java.lang.reflect.Type getType() {
                return cls;
            }
        };
    }

    public static abstract class StaticArrayTypeReference<T extends Type>
    extends TypeReference<T> {
        private final int size;

        protected StaticArrayTypeReference(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }
    }
}

