/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.util;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class PoiSheetUtil {
    public static void deleteColumn(Sheet sheet, int columnToDelete) {
        int maxColumn = 0;
        for (int r = 0; r < sheet.getLastRowNum() + 1; ++r) {
            Row row = sheet.getRow(r);
            if (row == null) continue;
            short lastColumn = row.getLastCellNum();
            if (lastColumn > maxColumn) {
                maxColumn = lastColumn;
            }
            if (lastColumn < columnToDelete) continue;
            for (int x = columnToDelete + 1; x < lastColumn + 1; ++x) {
                Cell nextCell;
                Cell oldCell = row.getCell(x - 1);
                if (oldCell != null) {
                    row.removeCell(oldCell);
                }
                if ((nextCell = row.getCell(x)) == null) continue;
                Cell newCell = row.createCell(x - 1, nextCell.getCellType());
                PoiSheetUtil.cloneCell(newCell, nextCell);
            }
        }
        for (int c = columnToDelete; c < maxColumn; ++c) {
            sheet.setColumnWidth(c, sheet.getColumnWidth(c + 1));
        }
    }

    private static void cloneCell(Cell cNew, Cell cOld) {
        cNew.setCellComment(cOld.getCellComment());
        cNew.setCellStyle(cOld.getCellStyle());
        switch (cNew.getCellType()) {
            case 4: {
                cNew.setCellValue(cOld.getBooleanCellValue());
                break;
            }
            case 0: {
                cNew.setCellValue(cOld.getNumericCellValue());
                break;
            }
            case 1: {
                cNew.setCellValue(cOld.getStringCellValue());
                break;
            }
            case 5: {
                cNew.setCellValue((double)cOld.getErrorCellValue());
                break;
            }
            case 2: {
                cNew.setCellFormula(cOld.getCellFormula());
                break;
            }
            default: {
                cNew.setCellValue(cOld.getStringCellValue());
            }
        }
    }
}

