/*
 * Decompiled with CFR 0.152.
 */
package com.lly835.bestpay.service.impl;

import com.lly835.bestpay.config.SignType;
import com.lly835.bestpay.config.WxPayConfig;
import com.lly835.bestpay.enums.BestPayPlatformEnum;
import com.lly835.bestpay.enums.BestPayTypeEnum;
import com.lly835.bestpay.enums.OrderStatusEnum;
import com.lly835.bestpay.model.DownloadBillRequest;
import com.lly835.bestpay.model.OrderQueryRequest;
import com.lly835.bestpay.model.OrderQueryResponse;
import com.lly835.bestpay.model.PayRequest;
import com.lly835.bestpay.model.PayResponse;
import com.lly835.bestpay.model.RefundRequest;
import com.lly835.bestpay.model.RefundResponse;
import com.lly835.bestpay.model.wxpay.WxPayApi;
import com.lly835.bestpay.model.wxpay.request.WxDownloadBillRequest;
import com.lly835.bestpay.model.wxpay.request.WxOrderQueryRequest;
import com.lly835.bestpay.model.wxpay.request.WxPayRefundRequest;
import com.lly835.bestpay.model.wxpay.request.WxPayUnifiedorderRequest;
import com.lly835.bestpay.model.wxpay.response.WxDownloadBillResponse;
import com.lly835.bestpay.model.wxpay.response.WxOrderQueryResponse;
import com.lly835.bestpay.model.wxpay.response.WxPayAsyncResponse;
import com.lly835.bestpay.model.wxpay.response.WxPaySyncResponse;
import com.lly835.bestpay.model.wxpay.response.WxRefundResponse;
import com.lly835.bestpay.service.impl.BestPayServiceImpl;
import com.lly835.bestpay.service.impl.WxPaySignature;
import com.lly835.bestpay.utils.MapUtil;
import com.lly835.bestpay.utils.MoneyUtil;
import com.lly835.bestpay.utils.RandomUtil;
import com.lly835.bestpay.utils.XmlUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.simplexml.SimpleXmlConverterFactory;

public class WxPayServiceImpl
extends BestPayServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(WxPayServiceImpl.class);
    private WxPayConfig wxPayConfig;
    private Retrofit retrofit = new Retrofit.Builder().baseUrl("https://api.mch.weixin.qq.com/").addConverterFactory((Converter.Factory)SimpleXmlConverterFactory.create()).client(new OkHttpClient.Builder().addInterceptor((Interceptor)new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY)).build()).build();

    @Override
    public void setWxPayConfig(WxPayConfig wxPayConfig) {
        this.wxPayConfig = wxPayConfig;
    }

    @Override
    public PayResponse pay(PayRequest request) {
        WxPayUnifiedorderRequest wxRequest = new WxPayUnifiedorderRequest();
        wxRequest.setOutTradeNo(request.getOrderId());
        wxRequest.setTotalFee(MoneyUtil.Yuan2Fen(request.getOrderAmount()));
        wxRequest.setBody(request.getOrderName());
        wxRequest.setOpenid(request.getOpenid());
        wxRequest.setTradeType(request.getPayTypeEnum().getCode());
        if (request.getPayTypeEnum() == BestPayTypeEnum.WXPAY_MINI) {
            wxRequest.setAppid(this.wxPayConfig.getMiniAppId());
        } else if (request.getPayTypeEnum() == BestPayTypeEnum.WXPAY_APP) {
            wxRequest.setAppid(this.wxPayConfig.getAppAppId());
        } else {
            wxRequest.setAppid(this.wxPayConfig.getAppId());
        }
        wxRequest.setMchId(this.wxPayConfig.getMchId());
        wxRequest.setNotifyUrl(this.wxPayConfig.getNotifyUrl());
        wxRequest.setNonceStr(RandomUtil.getRandomStr());
        wxRequest.setSpbillCreateIp(StringUtils.isEmpty((CharSequence)request.getSpbillCreateIp()) ? "8.8.8.8" : request.getSpbillCreateIp());
        wxRequest.setAttach(request.getAttach());
        wxRequest.setSign(WxPaySignature.sign(MapUtil.buildMap(wxRequest), this.wxPayConfig.getMchKey()));
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/xml; charset=utf-8"), (String)XmlUtil.toString(wxRequest));
        Call<WxPaySyncResponse> call = ((WxPayApi)this.retrofit.create(WxPayApi.class)).unifiedorder(body);
        Response retrofitResponse = null;
        try {
            retrofitResponse = call.execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        assert (retrofitResponse != null);
        if (!retrofitResponse.isSuccessful()) {
            throw new RuntimeException("\u3010\u5fae\u4fe1\u7edf\u4e00\u652f\u4ed8\u3011\u53d1\u8d77\u652f\u4ed8, \u7f51\u7edc\u5f02\u5e38");
        }
        WxPaySyncResponse response = (WxPaySyncResponse)retrofitResponse.body();
        assert (response != null);
        if (!response.getReturnCode().equals("SUCCESS")) {
            throw new RuntimeException("\u3010\u5fae\u4fe1\u7edf\u4e00\u652f\u4ed8\u3011\u53d1\u8d77\u652f\u4ed8, returnCode != SUCCESS, returnMsg = " + response.getReturnMsg());
        }
        if (!response.getResultCode().equals("SUCCESS")) {
            throw new RuntimeException("\u3010\u5fae\u4fe1\u7edf\u4e00\u652f\u4ed8\u3011\u53d1\u8d77\u652f\u4ed8, resultCode != SUCCESS, err_code = " + response.getErrCode() + " err_code_des=" + response.getErrCodeDes());
        }
        return this.buildPayResponse(response);
    }

    public boolean verify(Map map, SignType signType, String sign) {
        return WxPaySignature.verify(map, this.wxPayConfig.getMchKey());
    }

    @Override
    public PayResponse syncNotify(HttpServletRequest request) {
        return null;
    }

    @Override
    public PayResponse asyncNotify(String notifyData) {
        if (!WxPaySignature.verify(XmlUtil.toMap(notifyData), this.wxPayConfig.getMchKey()).booleanValue()) {
            log.error("\u3010\u5fae\u4fe1\u652f\u4ed8\u5f02\u6b65\u901a\u77e5\u3011\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25, response={}", (Object)notifyData);
            throw new RuntimeException("\u3010\u5fae\u4fe1\u652f\u4ed8\u5f02\u6b65\u901a\u77e5\u3011\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        WxPayAsyncResponse asyncResponse = (WxPayAsyncResponse)XmlUtil.toObject(notifyData, WxPayAsyncResponse.class);
        if (!asyncResponse.getReturnCode().equals("SUCCESS")) {
            throw new RuntimeException("\u3010\u5fae\u4fe1\u652f\u4ed8\u5f02\u6b65\u901a\u77e5\u3011\u53d1\u8d77\u652f\u4ed8, returnCode != SUCCESS, returnMsg = " + asyncResponse.getReturnMsg());
        }
        if (!asyncResponse.getResultCode().equals("SUCCESS") && asyncResponse.getErrCode().equals("ORDERPAID")) {
            return this.buildPayResponse(asyncResponse);
        }
        if (!asyncResponse.getResultCode().equals("SUCCESS")) {
            throw new RuntimeException("\u3010\u5fae\u4fe1\u652f\u4ed8\u5f02\u6b65\u901a\u77e5\u3011\u53d1\u8d77\u652f\u4ed8, resultCode != SUCCESS, err_code = " + asyncResponse.getErrCode() + " err_code_des=" + asyncResponse.getErrCodeDes());
        }
        return this.buildPayResponse(asyncResponse);
    }

    @Override
    public RefundResponse refund(RefundRequest request) {
        WxPayRefundRequest wxRequest = new WxPayRefundRequest();
        wxRequest.setOutTradeNo(request.getOrderId());
        wxRequest.setOutRefundNo(request.getOrderId());
        wxRequest.setTotalFee(MoneyUtil.Yuan2Fen(request.getOrderAmount()));
        wxRequest.setRefundFee(MoneyUtil.Yuan2Fen(request.getOrderAmount()));
        wxRequest.setAppid(this.wxPayConfig.getAppId());
        wxRequest.setMchId(this.wxPayConfig.getMchId());
        wxRequest.setNonceStr(RandomUtil.getRandomStr());
        wxRequest.setSign(WxPaySignature.sign(MapUtil.buildMap(wxRequest), this.wxPayConfig.getMchKey()));
        if (this.wxPayConfig.getSslContext() == null) {
            this.wxPayConfig.initSSLContext();
        }
        OkHttpClient okHttpClient = new OkHttpClient().newBuilder().sslSocketFactory(this.wxPayConfig.getSslContext().getSocketFactory()).addInterceptor((Interceptor)new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY)).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl("https://api.mch.weixin.qq.com/").addConverterFactory((Converter.Factory)SimpleXmlConverterFactory.create()).client(okHttpClient).build();
        String xml = XmlUtil.toString(wxRequest);
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/xml; charset=utf-8"), (String)xml);
        Call<WxRefundResponse> call = ((WxPayApi)retrofit.create(WxPayApi.class)).refund(body);
        Response retrofitResponse = null;
        try {
            retrofitResponse = call.execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!retrofitResponse.isSuccessful()) {
            throw new RuntimeException("\u3010\u5fae\u4fe1\u9000\u6b3e\u3011\u53d1\u8d77\u9000\u6b3e, \u7f51\u7edc\u5f02\u5e38");
        }
        WxRefundResponse response = (WxRefundResponse)retrofitResponse.body();
        if (!response.getReturnCode().equals("SUCCESS")) {
            throw new RuntimeException("\u3010\u5fae\u4fe1\u9000\u6b3e\u3011\u53d1\u8d77\u9000\u6b3e, returnCode != SUCCESS, returnMsg = " + response.getReturnMsg());
        }
        if (!response.getResultCode().equals("SUCCESS")) {
            throw new RuntimeException("\u3010\u5fae\u4fe1\u9000\u6b3e\u3011\u53d1\u8d77\u9000\u6b3e, resultCode != SUCCESS, err_code = " + response.getErrCode() + " err_code_des=" + response.getErrCodeDes());
        }
        return this.buildRefundResponse(response);
    }

    @Override
    public OrderQueryResponse query(OrderQueryRequest request) {
        WxOrderQueryRequest wxRequest = new WxOrderQueryRequest();
        wxRequest.setOutTradeNo(request.getOrderId());
        wxRequest.setTransactionId(request.getOutOrderId());
        wxRequest.setAppid(this.wxPayConfig.getAppId());
        wxRequest.setMchId(this.wxPayConfig.getMchId());
        wxRequest.setNonceStr(RandomUtil.getRandomStr());
        wxRequest.setSign(WxPaySignature.sign(MapUtil.buildMap(wxRequest), this.wxPayConfig.getMchKey()));
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/xml; charset=utf-8"), (String)XmlUtil.toString(wxRequest));
        Call<WxOrderQueryResponse> call = ((WxPayApi)this.retrofit.create(WxPayApi.class)).orderquery(body);
        Response retrofitResponse = null;
        try {
            retrofitResponse = call.execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        assert (retrofitResponse != null);
        if (!retrofitResponse.isSuccessful()) {
            throw new RuntimeException("\u3010\u5fae\u4fe1\u8ba2\u5355\u67e5\u8be2\u3011\u7f51\u7edc\u5f02\u5e38");
        }
        WxOrderQueryResponse response = (WxOrderQueryResponse)retrofitResponse.body();
        assert (response != null);
        if (!response.getReturnCode().equals("SUCCESS")) {
            throw new RuntimeException("\u3010\u5fae\u4fe1\u8ba2\u5355\u67e5\u8be2\u3011returnCode != SUCCESS, returnMsg = " + response.getReturnMsg());
        }
        if (!response.getResultCode().equals("SUCCESS")) {
            throw new RuntimeException("\u3010\u5fae\u4fe1\u8ba2\u5355\u67e5\u8be2\u3011resultCode != SUCCESS, err_code = " + response.getErrCode() + ", err_code_des=" + response.getErrCodeDes());
        }
        return OrderQueryResponse.builder().orderStatusEnum(OrderStatusEnum.findByName(response.getTradeState())).resultMsg(response.getTradeStateDesc()).outTradeNo(response.getTransactionId()).orderId(response.getOutTradeNo()).attach(response.getAttach()).finishTime(response.getTimeEnd().replaceAll("(\\d{4})(\\d{2})(\\d{2})(\\d{2})(\\d{2})(\\d{2})", "$1-$2-$3 $4:$5:$6")).build();
    }

    private RefundResponse buildRefundResponse(WxRefundResponse response) {
        RefundResponse refundResponse = new RefundResponse();
        refundResponse.setOrderId(response.getOutTradeNo());
        refundResponse.setOrderAmount(MoneyUtil.Fen2Yuan(response.getTotalFee()));
        refundResponse.setOutTradeNo(response.getTransactionId());
        refundResponse.setRefundId(response.getOutRefundNo());
        refundResponse.setOutRefundNo(response.getRefundId());
        return refundResponse;
    }

    private PayResponse buildPayResponse(WxPayAsyncResponse response) {
        PayResponse payResponse = new PayResponse();
        payResponse.setPayPlatformEnum(BestPayPlatformEnum.WX);
        payResponse.setOrderAmount(MoneyUtil.Fen2Yuan(response.getTotalFee()));
        payResponse.setOrderId(response.getOutTradeNo());
        payResponse.setOutTradeNo(response.getTransactionId());
        payResponse.setAttach(response.getAttach());
        payResponse.setMwebUrl(response.getMwebUrl());
        return payResponse;
    }

    private PayResponse buildPayResponse(WxPaySyncResponse response) {
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String nonceStr = RandomUtil.getRandomStr();
        String packAge = "prepay_id=" + response.getPrepayId();
        String signType = "MD5";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appId", response.getAppid());
        map.put("timeStamp", timeStamp);
        map.put("nonceStr", nonceStr);
        map.put("package", packAge);
        map.put("signType", signType);
        PayResponse payResponse = new PayResponse();
        payResponse.setAppId(response.getAppid());
        payResponse.setTimeStamp(timeStamp);
        payResponse.setNonceStr(nonceStr);
        payResponse.setPackAge(packAge);
        payResponse.setSignType(signType);
        payResponse.setPaySign(WxPaySignature.sign(map, this.wxPayConfig.getMchKey()));
        payResponse.setMwebUrl(response.getMwebUrl());
        payResponse.setCodeUrl(response.getCodeUrl());
        return payResponse;
    }

    @Override
    public String downloadBill(DownloadBillRequest request) {
        WxDownloadBillRequest wxRequest = new WxDownloadBillRequest();
        wxRequest.setBillDate(request.getBillDate());
        wxRequest.setAppid(this.wxPayConfig.getAppId());
        wxRequest.setMchId(this.wxPayConfig.getMchId());
        wxRequest.setNonceStr(RandomUtil.getRandomStr());
        wxRequest.setSign(WxPaySignature.sign(MapUtil.buildMap(wxRequest), this.wxPayConfig.getMchKey()));
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/xml; charset=utf-8"), (String)XmlUtil.toString(wxRequest));
        Call<ResponseBody> call = ((WxPayApi)this.retrofit.create(WxPayApi.class)).downloadBill(body);
        Response retrofitResponse = null;
        try {
            retrofitResponse = call.execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!retrofitResponse.isSuccessful()) {
            throw new RuntimeException("\u3010\u5fae\u4fe1\u8ba2\u5355\u67e5\u8be2\u3011\u7f51\u7edc\u5f02\u5e38");
        }
        String response = null;
        try {
            response = ((ResponseBody)retrofitResponse.body()).string();
            if (response.startsWith("<")) {
                WxDownloadBillResponse downloadBillResponse = (WxDownloadBillResponse)XmlUtil.toObject(response, WxDownloadBillResponse.class);
                throw new RuntimeException("\u3010\u5bf9\u8d26\u6587\u4ef6\u3011\u8fd4\u56de\u5f02\u5e38 \u9519\u8bef\u7801: " + downloadBillResponse.getErrorCode() + " \u9519\u8bef\u4fe1\u606f: " + downloadBillResponse.getReturnMsg());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    @Override
    public String getQrCodeUrl(String productId) {
        String appid = this.wxPayConfig.getAppId();
        String mch_id = this.wxPayConfig.getMchId();
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String nonceStr = RandomUtil.getRandomStr();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appid", appid);
        map.put("mch_id", mch_id);
        map.put("product_id", productId);
        map.put("time_stamp", timeStamp);
        map.put("nonce_str", nonceStr);
        return "weixin://wxpay/bizpayurl?appid=" + appid + "&mch_id=" + mch_id + "&product_id=" + productId + "&time_stamp=" + timeStamp + "&nonce_str=" + nonceStr + "&sign=" + WxPaySignature.sign(map, this.wxPayConfig.getMchKey());
    }
}

