/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven;

import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.PaddedCell;
import com.diffplug.spotless.extra.integration.DiffMessageFormatter;
import com.diffplug.spotless.maven.AbstractSpotlessMojo;
import com.diffplug.spotless.maven.ImpactedFilesTracker;
import com.diffplug.spotless.maven.incremental.UpToDateChecker;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class SpotlessCheckMojo
extends AbstractSpotlessMojo {
    @Override
    protected void process(Iterable<File> files, Formatter formatter, UpToDateChecker upToDateChecker) throws MojoExecutionException {
        ImpactedFilesTracker counter = new ImpactedFilesTracker();
        ArrayList<File> problemFiles = new ArrayList<File>();
        for (File file : files) {
            if (upToDateChecker.isUpToDate(file.toPath())) {
                counter.skippedAsCleanCache();
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Spotless will not check an up-to-date file: " + file));
                continue;
            }
            try {
                PaddedCell.DirtyState dirtyState = PaddedCell.calculateDirtyState((Formatter)formatter, (File)file);
                if (!dirtyState.isClean() && !dirtyState.didNotConverge()) {
                    problemFiles.add(file);
                    counter.cleaned();
                    continue;
                }
                counter.checkedButAlreadyClean();
                upToDateChecker.setUpToDate(file.toPath());
            }
            catch (IOException | RuntimeException e) {
                throw new MojoExecutionException("Unable to format file " + file, e);
            }
        }
        if (counter.getTotal() > 0) {
            this.getLog().info((CharSequence)String.format("Spotless.%s is keeping %s files clean - %s needs changes to be clean, %s were already clean, %s were skipped because caching determined they were already clean", formatter.getName(), counter.getTotal(), counter.getCleaned(), counter.getCheckedButAlreadyClean(), counter.getSkippedAsCleanCache()));
        } else {
            this.getLog().debug((CharSequence)String.format("Spotless.%s has no target files. Examine your `<includes>`: https://github.com/diffplug/spotless/tree/main/plugin-maven#quickstart", formatter.getName()));
        }
        if (!problemFiles.isEmpty()) {
            throw new MojoExecutionException(DiffMessageFormatter.builder().runToFix("Run 'mvn spotless:apply' to fix these violations.").formatter(formatter).problemFiles(problemFiles).getMessage());
        }
    }
}

