/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.text.pdf.internal;

import java.io.IOException;
import org.openpdf.text.DocWriter;
import org.openpdf.text.pdf.OutputStreamCounter;
import org.openpdf.text.pdf.PdfDeveloperExtension;
import org.openpdf.text.pdf.PdfDictionary;
import org.openpdf.text.pdf.PdfName;
import org.openpdf.text.pdf.PdfWriter;
import org.openpdf.text.pdf.interfaces.PdfVersion;

public class PdfVersionImp
implements PdfVersion {
    public static final byte[][] HEADER = new byte[][]{DocWriter.getISOBytes("\n"), DocWriter.getISOBytes("%PDF-"), DocWriter.getISOBytes("\n%\u00e2\u00e3\u00cf\u00d3\n")};
    protected boolean headerWasWritten = false;
    protected boolean appendmode = false;
    protected String header_version = "2.0";
    protected PdfName catalog_version = null;
    protected PdfDictionary extensions = null;

    @Override
    public void setPdfVersion(String version) {
        if (this.headerWasWritten || this.appendmode) {
            this.setPdfVersion(this.getVersionAsName(version));
        } else {
            this.header_version = version;
        }
    }

    @Override
    public void setAtLeastPdfVersion(String version) {
        if (this.comparePdfVersions(version, this.header_version) > 0) {
            this.setPdfVersion(version);
        }
    }

    public int comparePdfVersions(String v1, String v2) {
        int major2;
        String[] p1 = v1.split("\\.");
        String[] p2 = v2.split("\\.");
        int major1 = Integer.parseInt(p1[0]);
        if (major1 != (major2 = Integer.parseInt(p2[0]))) {
            return Integer.compare(major1, major2);
        }
        int minor1 = p1.length > 1 ? Integer.parseInt(p1[1]) : 0;
        int minor2 = p2.length > 1 ? Integer.parseInt(p2[1]) : 0;
        return Integer.compare(minor1, minor2);
    }

    @Override
    public void setPdfVersion(PdfName version) {
        if (this.catalog_version == null || this.catalog_version.compareTo(version) < 0) {
            this.catalog_version = version;
        }
    }

    public void setAppendmode(boolean appendmode) {
        this.appendmode = appendmode;
    }

    public void writeHeader(OutputStreamCounter os) throws IOException {
        if (this.appendmode) {
            os.write(HEADER[0]);
        } else {
            os.write(HEADER[1]);
            os.write(this.getVersionAsByteArray(this.header_version));
            os.write(HEADER[2]);
            this.headerWasWritten = true;
        }
    }

    public PdfName getVersionAsName(String version) {
        switch (version) {
            case "1.2": {
                return PdfWriter.PDF_VERSION_1_2;
            }
            case "1.3": {
                return PdfWriter.PDF_VERSION_1_3;
            }
            case "1.4": {
                return PdfWriter.PDF_VERSION_1_4;
            }
            case "1.5": {
                return PdfWriter.PDF_VERSION_1_5;
            }
            case "1.6": {
                return PdfWriter.PDF_VERSION_1_6;
            }
            case "1.7": {
                return PdfWriter.PDF_VERSION_1_7;
            }
            case "2.0": {
                return PdfWriter.PDF_VERSION_2_0;
            }
        }
        return PdfWriter.PDF_VERSION_2_0;
    }

    public byte[] getVersionAsByteArray(String version) {
        return DocWriter.getISOBytes(this.getVersionAsName(version).toString().substring(1));
    }

    public void addToCatalog(PdfDictionary catalog) {
        if (this.catalog_version != null) {
            catalog.put(PdfName.VERSION, this.catalog_version);
        }
        if (this.extensions != null) {
            catalog.put(PdfName.EXTENSIONS, this.extensions);
        }
    }

    @Override
    public void addDeveloperExtension(PdfDeveloperExtension de) {
        if (this.extensions == null) {
            this.extensions = new PdfDictionary();
        } else {
            PdfDictionary extension = this.extensions.getAsDict(de.getPrefix());
            if (extension != null) {
                int diff = de.getBaseversion().compareTo(extension.getAsName(PdfName.BASEVERSION));
                if (diff < 0) {
                    return;
                }
                diff = de.getExtensionLevel() - extension.getAsNumber(PdfName.EXTENSIONLEVEL).intValue();
                if (diff <= 0) {
                    return;
                }
            }
        }
        this.extensions.put(de.getPrefix(), de.getDeveloperExtensions());
    }
}

