/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.text.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;

public final class PdfBatch {
    private PdfBatch() {
    }

    public static <T> BatchResult<T> run(Collection<? extends Callable<T>> tasks, Consumer<T> onSuccess, Consumer<Throwable> onFailure) {
        Objects.requireNonNull(tasks, "tasks");
        BatchResult result = new BatchResult();
        if (tasks.isEmpty()) {
            return result;
        }
        try (ExecutorService exec = Executors.newVirtualThreadPerTaskExecutor();){
            List<Future> futures = tasks.stream().map(exec::submit).toList();
            for (Future f : futures) {
                try {
                    Object v = f.get();
                    result.successes.add(v);
                    if (onSuccess == null) continue;
                    onSuccess.accept(v);
                }
                catch (ExecutionException ee) {
                    Throwable cause = ee.getCause() != null ? ee.getCause() : ee;
                    result.failures.add(cause);
                    if (onFailure == null) continue;
                    onFailure.accept(cause);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    result.failures.add(ie);
                    if (onFailure == null) continue;
                    onFailure.accept(ie);
                }
            }
        }
        return result;
    }

    public static final class BatchResult<T> {
        public final List<T> successes = new ArrayList<T>();
        public final List<Throwable> failures = new ArrayList<Throwable>();

        public boolean isAllSuccessful() {
            return this.failures.isEmpty();
        }

        public int total() {
            return this.successes.size() + this.failures.size();
        }

        public String toString() {
            return "BatchResult{successes=" + this.successes.size() + ", failures=" + this.failures.size() + ", total=" + this.total() + "}";
        }
    }
}

