/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.webp;

import io.github.biezhi.webp.WebpIOException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Objects;

public class WebpIO {
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    private static final String OS_ARCH = System.getProperty("os.arch").toLowerCase();
    private static final String DEV_MODE = System.getProperty("webp-io.devMode", "false");
    private String commandDir;
    private String webpTmpDir = "cwebp_tmp";

    public WebpIO() {
        this.init();
    }

    private void init() {
        String osName = this.getOsName();
        String webpPath = "cwebp/" + osName;
        if (Boolean.TRUE.toString().equals(DEV_MODE.toUpperCase())) {
            this.commandDir = WebpIO.class.getResource("/").getPath() + webpPath;
            return;
        }
        File tmp = new File(this.webpTmpDir);
        if (!tmp.exists()) {
            tmp.mkdirs();
        }
        this.commandDir = tmp.getPath();
        String extension = this.getExtensionByOs(osName);
        InputStream dwebp = this.getInputStream("/" + webpPath + "/dwebp" + extension);
        InputStream cwebp = this.getInputStream("/" + webpPath + "/cwebp" + extension);
        InputStream gif2webp = this.getInputStream("/" + webpPath + "/gif2webp" + extension);
        try {
            this.copy(dwebp, new File(tmp.getPath() + "/dwebp" + extension));
            this.copy(cwebp, new File(tmp.getPath() + "/cwebp" + extension));
            this.copy(gif2webp, new File(tmp.getPath() + "/gif2webp" + extension));
        }
        catch (Exception e) {
            throw new WebpIOException(e);
        }
    }

    public static WebpIO create() {
        return new WebpIO();
    }

    private InputStream getInputStream(String subPath) {
        return WebpIO.class.getResourceAsStream(subPath);
    }

    public void toNormalImage(String src, String dest) {
        this.toNormalImage(new File(src), new File(dest));
    }

    public void toNormalImage(File src, File dest) {
        String command = this.commandDir + (dest.getName().endsWith(".gif") ? "/gif2webp" : "/dwebp ") + src.getPath() + " -o " + dest.getPath();
        this.executeCommand(command);
    }

    public void toWEBP(String src, String dest) {
        this.toWEBP(new File(src), new File(dest));
    }

    public void toWEBP(File src, File dest) {
        try {
            String command = this.commandDir + (src.getName().endsWith(".gif") ? "/gif2webp " : "/cwebp ") + src.getPath() + " -o " + dest.getPath();
            this.executeCommand(command);
        }
        catch (Exception e) {
            throw new WebpIOException(e);
        }
    }

    private String executeCommand(String command) {
        System.out.println("Execute: " + command);
        StringBuilder output = new StringBuilder();
        try {
            String line;
            Process p = Runtime.getRuntime().exec(command);
            p.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = reader.readLine()) != null) {
                output.append(line).append("\n");
            }
        }
        catch (Exception e) {
            throw new WebpIOException(e);
        }
        if (!"".equals(output.toString())) {
            System.out.println("Output: " + output);
        }
        return "";
    }

    public void close() {
        File tmp = new File(this.webpTmpDir);
        if (tmp.exists() && tmp.isDirectory()) {
            File[] files = tmp.listFiles();
            for (File file : Objects.requireNonNull(files)) {
                file.delete();
            }
            tmp.delete();
        }
    }

    private void copy(InputStream in, File dest) throws IOException {
        int length;
        FileOutputStream out = new FileOutputStream(dest);
        byte[] buffer = new byte[1024];
        while ((length = in.read(buffer)) > 0) {
            ((OutputStream)out).write(buffer, 0, length);
        }
        dest.setExecutable(true);
        in.close();
        ((OutputStream)out).close();
    }

    private String getOsName() {
        if (OS_NAME.contains("win")) {
            boolean is64bit = System.getenv("ProgramFiles(x86)") != null;
            return "windows_" + (is64bit ? "x86_64" : "x86");
        }
        if (OS_NAME.contains("mac")) {
            return "mac_" + OS_ARCH;
        }
        if (OS_NAME.contains("nix") || OS_NAME.contains("nux") || OS_NAME.indexOf("aix") > 0) {
            return "amd64".equalsIgnoreCase(OS_ARCH) ? "linux_x86_64" : "linux_" + OS_ARCH;
        }
        throw new WebpIOException("Hi boy, Your OS is not support!!");
    }

    private String getExtensionByOs(String os) {
        if (os == null || os.isEmpty()) {
            return "";
        }
        if (os.contains("win")) {
            return ".exe";
        }
        return "";
    }
}

