/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.inference.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.openapitools.inference.client.JSON;
import org.openapitools.inference.client.model.Embedding;
import org.openapitools.inference.client.model.EmbeddingsListUsage;

public class EmbeddingsList {
    public static final String SERIALIZED_NAME_MODEL = "model";
    @SerializedName(value="model")
    private String model;
    public static final String SERIALIZED_NAME_VECTOR_TYPE = "vector_type";
    @SerializedName(value="vector_type")
    private String vectorType;
    public static final String SERIALIZED_NAME_DATA = "data";
    @SerializedName(value="data")
    private List<Embedding> data = new ArrayList<Embedding>();
    public static final String SERIALIZED_NAME_USAGE = "usage";
    @SerializedName(value="usage")
    private EmbeddingsListUsage usage;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public EmbeddingsList model(String model) {
        this.model = model;
        return this;
    }

    @Nonnull
    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public EmbeddingsList vectorType(String vectorType) {
        this.vectorType = vectorType;
        return this;
    }

    @Nonnull
    public String getVectorType() {
        return this.vectorType;
    }

    public void setVectorType(String vectorType) {
        this.vectorType = vectorType;
    }

    public EmbeddingsList data(List<Embedding> data) {
        this.data = data;
        return this;
    }

    public EmbeddingsList addDataItem(Embedding dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<Embedding>();
        }
        this.data.add(dataItem);
        return this;
    }

    @Nonnull
    public List<Embedding> getData() {
        return this.data;
    }

    public void setData(List<Embedding> data) {
        this.data = data;
    }

    public EmbeddingsList usage(EmbeddingsListUsage usage) {
        this.usage = usage;
        return this;
    }

    @Nonnull
    public EmbeddingsListUsage getUsage() {
        return this.usage;
    }

    public void setUsage(EmbeddingsListUsage usage) {
        this.usage = usage;
    }

    public EmbeddingsList putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmbeddingsList embeddingsList = (EmbeddingsList)o;
        return Objects.equals(this.model, embeddingsList.model) && Objects.equals(this.vectorType, embeddingsList.vectorType) && Objects.equals(this.data, embeddingsList.data) && Objects.equals(this.usage, embeddingsList.usage) && Objects.equals(this.additionalProperties, embeddingsList.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.vectorType, this.data, this.usage, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmbeddingsList {\n");
        sb.append("    model: ").append(this.toIndentedString(this.model)).append("\n");
        sb.append("    vectorType: ").append(this.toIndentedString(this.vectorType)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    usage: ").append(this.toIndentedString(this.usage)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in EmbeddingsList is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_MODEL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `model` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MODEL).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_VECTOR_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `vector_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VECTOR_TYPE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_DATA).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `data` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DATA).toString()));
        }
        JsonArray jsonArraydata = jsonObj.getAsJsonArray(SERIALIZED_NAME_DATA);
        for (int i = 0; i < jsonArraydata.size(); ++i) {
            Embedding.validateJsonElement(jsonArraydata.get(i));
        }
        EmbeddingsListUsage.validateJsonElement(jsonObj.get(SERIALIZED_NAME_USAGE));
    }

    public static EmbeddingsList fromJson(String jsonString) throws IOException {
        return (EmbeddingsList)JSON.getGson().fromJson(jsonString, EmbeddingsList.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_MODEL);
        openapiFields.add(SERIALIZED_NAME_VECTOR_TYPE);
        openapiFields.add(SERIALIZED_NAME_DATA);
        openapiFields.add(SERIALIZED_NAME_USAGE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_MODEL);
        openapiRequiredFields.add(SERIALIZED_NAME_VECTOR_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_DATA);
        openapiRequiredFields.add(SERIALIZED_NAME_USAGE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!EmbeddingsList.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(EmbeddingsList.class));
            return new TypeAdapter<EmbeddingsList>(){

                public void write(JsonWriter out, EmbeddingsList value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public EmbeddingsList read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    EmbeddingsList.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    EmbeddingsList instance = (EmbeddingsList)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

