/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Optional;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Maps;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.spi.schema.contexts.ModelContext;

public class ModelRefs {
    private ModelRefs() {
        throw new UnsupportedOperationException();
    }

    public static Optional<ModelRef> modelRef(Optional<ResolvedType> type, ModelContext modelContext, TypeNameExtractor nameExtractor) {
        if (!type.isPresent()) {
            return Optional.absent();
        }
        return Optional.of((Object)ModelRefs.modelRef((ResolvedType)type.get(), modelContext, nameExtractor));
    }

    public static ModelRef modelRef(ResolvedType resolved, ModelContext modelContext, TypeNameExtractor nameExtractor) {
        if (Collections.isContainerType((ResolvedType)resolved)) {
            ResolvedType collectionElementType = Collections.collectionElementType((ResolvedType)resolved);
            String elementTypeName = nameExtractor.typeName(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)collectionElementType));
            return new ModelRef(Collections.containerType((ResolvedType)resolved), elementTypeName);
        }
        if (Maps.isMapType((ResolvedType)resolved)) {
            String elementTypeName = nameExtractor.typeName(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)Maps.mapValueType((ResolvedType)resolved)));
            return new ModelRef("Map", elementTypeName, true);
        }
        if (Void.class.equals((Object)resolved.getErasedType()) || Void.TYPE.equals(resolved.getErasedType())) {
            return new ModelRef("void");
        }
        String typeName = nameExtractor.typeName(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)resolved));
        return new ModelRef(typeName);
    }
}

