/*
 * Copyright 2016-2019 Crown Copyright
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package uk.gov.gchq.gaffer.commonutil.iterable;

/**
 * An {@code AlwaysValid} is an {@link uk.gov.gchq.gaffer.commonutil.iterable.Validator} in which it always returns true.
 *
 * @param <T> the type of object to validate
 */
public class AlwaysValid<T> implements Validator<T> {
    @Override
    public boolean validate(final T obj) {
        return true;
    }
}
