package com.crawler.push.bean;

import java.util.UUID;

import com.crawler.push.config.JacksonObjectMapper;
import com.crawler.push.config.PushProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * 推送体
 * @author rubekid
 * @date 2016年9月13日
 */
@JsonInclude(Include.NON_NULL)
public class PushBody{
	
	/**
	 * 默认图标
	 */
	public static final String PUSH_ICON = PushProperties.getProperty("jpush.icon");
	
	/**
	 * 消息ID
	 */
	private String msgId = UUID.randomUUID().toString();
	
	/**
	 * 图标
	 */
	private String icon = PUSH_ICON;
	
	/**
	 * 标题
	 */
	private String title = "系统通知";
	
	/**
	 * 内容
	 */
	private String content;
	
	/**
	 * 是否删除
	 */
	private Integer deletable;
	
	/**
	 * 类型
	 */
	private Integer type;
	
	/**
	 * 分组
	 */
	private String msgGroup;
	
	/**
	 * 时间戳
	 */
	private Long date = System.currentTimeMillis();
	
	/**
	 * 连接
	 */
	private String link;
	
	/**
	 * 扩展
	 */
	private Object extra;

	public String getMsgId() {
		return msgId;
	}

	public void setMsgId(String msgId) {
		this.msgId = msgId;
	}

	public String getIcon() {
		return icon;
	}

	public void setIcon(String icon) {
		this.icon = icon;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public Integer getDeletable() {
		return deletable;
	}

	public void setDeletable(Integer deletable) {
		this.deletable = deletable;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getMsgGroup() {
		return msgGroup;
	}

	public void setMsgGroup(String group) {
		this.msgGroup = group;
	}

	public Long getDate() {
		return date;
	}

	public void setDate(Long date) {
		this.date = date;
	}

	public String getLink() {
		return link;
	}

	public void setLink(String link) {
		this.link = link;
	}

	public Object getExtra() {
		return extra;
	}

	public void setExtra(Object extra) {
		this.extra = extra;
	}
	
	@Override
	public String toString() {
		ObjectMapper objectMapper = new JacksonObjectMapper();
		try {
			return objectMapper.writeValueAsString(this);
		} catch (JsonProcessingException e) {
			e.printStackTrace();
		}
		return "";
	}
}
