package com.crawler.push.common;

import java.util.List;

import com.crawler.push.bean.PushBody;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 推送
 *
 */
public interface Pushable {


	/**
	 * 别名推送
	 * @param alias
	 * @param pushBody
	 */
	public void pushToAlias(String alias, PushBody pushBody);
	
	/**
	 * 别名推送
	 * @param alias
	 * @param pushBody
	 */
	public void pushToAlias(List<Object> alias, PushBody pushBody);
	
	
	/**
	 * 发送给别名列表
	 * @param alias
	 * @param title
	 * @param content
	 */
	public void sendPushByAlias(List<String> aliasList, PushBody pushBody);
	
	/**
	 * 发送给tag分组
	 * @param alias
	 * @param pushBody
	 * @throws JsonProcessingException
	 */
	public void pushToTags(List<Object> tags, PushBody pushBody);
	
	/**
	 * 发送给tag分组列表
	 * @param tags
	 * @param title
	 * @param content
	 */
	public void sendPushByTags(List<String> tags, PushBody pushBody);
	    
    /**
	 * 发送通知
	 * @param pushMsg
	 */
	public void notification(PushBody pushBody);
}
