package com.crawler.push.common;

import java.util.Arrays;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.crawler.push.bean.MsgItem;
import com.crawler.push.bean.PushBody;
import com.crawler.push.config.PushProperties;

/**
 * 推送
 * @author rubekid
 *
 * 2017年6月13日 下午5:49:08
 */
public class Pusher {

	private static final Logger LOGGER = LoggerFactory.getLogger(Pusher.class);

	public static final String MODE = PushProperties.getProperty("push.mode");
	
	public static final String MODE_GETUI = "getui";
	public static final String MOdE_JPUSH = "jpush";
	
	/**
	 * 其他
	 */
	public static final int MSG_TYPE_OTHERS = 0;
	
	

	/**
	 * 发送
	 * 
	 * @param msg
	 * @param targetUserIds
	 */
	public static void pushToAlias(final PushBody msg, final Object... targetUserIds) {

		new Thread(new Runnable() {
			@Override
			public void run() {
				try {
					Thread.currentThread();
					Thread.sleep(300);

					Integer msgType = msg.getType();
					if (msgType == null) {
						msgType = MSG_TYPE_OTHERS;
						msg.setType(msgType);
					}
					if (msg.getDeletable() == null) {
						msg.setDeletable(1);
					}
					List<Object> alias = Arrays.asList(targetUserIds);
					Pushable pushable = getPushable();
					pushable.pushToAlias(alias, msg);

				} catch (InterruptedException ex) {
					LOGGER.error(ex.getMessage(), ex);
				}
			}
		}) {
		}.start();

	}
	
	/**
	 * 群发（推送给Tag分组）
	 * 
	 * @param msg
	 * @param targetUserIds
	 */
	public static void pushByTags(final PushBody msg, final Object... targetTags) {

		new Thread(new Runnable() {
			@Override
			public void run() {
				try {
					Thread.currentThread();
					Thread.sleep(300);

					Integer msgType = msg.getType();
					if (msgType == null) {
						msgType = MSG_TYPE_OTHERS;
						msg.setType(msgType);
					}
					if (msg.getDeletable() == null) {
						msg.setDeletable(1);
					}
					List<Object> tags = Arrays.asList(targetTags);
					Pushable pushable = getPushable();
					pushable.pushToTags(tags, msg);

				} catch (InterruptedException ex) {
					LOGGER.error(ex.getMessage(), ex);
				}
			}
		}) {
		}.start();

	}
	
	/**
	 * 系统通知
	 * @param pushMsg
	 */
	public static void pushNotification(final PushBody msg){
		new Thread(new Runnable() {
			@Override
			public void run() {
				try {
					Thread.currentThread();
					Thread.sleep(300);
					
					Integer msgType = msg.getType();
					if (msgType == null) {
						msgType = MSG_TYPE_OTHERS;
						msg.setType(msgType);
					}
					if (msg.getDeletable() == null) {
						msg.setDeletable(1);
					}
					
					Pushable pushable = getPushable();
					pushable.notification(msg);

				} catch (InterruptedException ex) {
					LOGGER.error(ex.getMessage(), ex);
				}
			}
		}) {
		}.start();
	}

	
	/**
	 * 推送
	 * 
	 * @param msg
	 * @param targets 推送对象数组
	 */
	public static void send(final PushBody msg, final Object... targets) {
		Pusher.pushToAlias(msg, targets);
	}

	/**
	 * 批量发送
	 * 
	 * @param msgItems
	 */
	public static void batchSend(final List<MsgItem> msgItems) {
		for (MsgItem msgItem : msgItems) {
			Pusher.pushToAlias(msgItem.getMsg(), msgItem.getTargetId());
		}
	}
	
	/**
	 * 群发（推送给tags）
	 * 
	 * @param msg
	 * @param targets 推送对象数组
	 */
	public static void mass(final PushBody msg, Object... targetTags) {
		Pusher.pushByTags(msg, targetTags);
	}
	
	/**
	 * 系统通知
	 * 
	 * @param msg
	 * @param targets 推送对象数组
	 */
	public static void notification(final PushBody msg) {
		Pusher.pushNotification(msg);
	}

	/**
	 * 获取推送
	 * @return
	 */
	public static Pushable getPushable(){
		if(MODE_GETUI.equals(MODE)){
			return new GePusher();
		}
		return new JPusher();
	}
	
	/**
	 * 使用CID
	 * @return
	 */
	public static boolean useCid(){
		return MODE_GETUI.equals(MODE);
	}

}
