package com.crawler.push.config;

import java.util.TimeZone;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;

public class JacksonObjectMapper extends ObjectMapper {
	private static final long serialVersionUID = -624755482354300157L;

	public JacksonObjectMapper() {
		//super.setDateFormat(DATE_FORMAT);
		super.setTimeZone(TimeZone.getTimeZone("GMT+8"));
		super.enable(JsonParser.Feature.ALLOW_SINGLE_QUOTES);
		// 设置时间为 ISO-8601 日期
		//super.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
		// 设置输入时忽略JSON字符串中存在而Java对象实际没有的属性
		super.enable(JsonParser.Feature.ALLOW_SINGLE_QUOTES);
		super.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
		// 设置将驼峰命名法转换成下划线的方式输入输出
		super.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
		super.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
		super.disable(SerializationFeature.WRITE_NULL_MAP_VALUES);
		// 设定是否使用Enum的toString函数来读取Enum, 为False时使用Enum的name()函数来读取Enum,
		super.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
		// 如果输入不存在的字段时不会报错
		super.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
		// 使用默认的Jsckson注解
		super.setAnnotationIntrospector(new JacksonAnnotationIntrospector());
	}

}