/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.push.common;

import com.crawler.push.bean.PushBody;
import com.crawler.push.common.Pushable;
import com.crawler.push.config.PushProperties;
import com.gexin.rp.sdk.base.IPushResult;
import com.gexin.rp.sdk.base.ITemplate;
import com.gexin.rp.sdk.base.impl.AppMessage;
import com.gexin.rp.sdk.base.impl.SingleMessage;
import com.gexin.rp.sdk.base.impl.Target;
import com.gexin.rp.sdk.base.payload.APNPayload;
import com.gexin.rp.sdk.base.payload.Payload;
import com.gexin.rp.sdk.base.uitls.AppConditions;
import com.gexin.rp.sdk.exceptions.RequestException;
import com.gexin.rp.sdk.http.IGtPush;
import com.gexin.rp.sdk.template.LinkTemplate;
import com.gexin.rp.sdk.template.NotificationTemplate;
import com.gexin.rp.sdk.template.TransmissionTemplate;
import com.gexin.rp.sdk.template.style.AbstractNotifyStyle;
import com.gexin.rp.sdk.template.style.Style0;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GePusher
implements Pushable {
    protected static final Logger LOG = LoggerFactory.getLogger(GePusher.class);
    private static String APP_ID = PushProperties.getProperty("getui.appId");
    private static String APP_KEY = PushProperties.getProperty("getui.appKey");
    private static String MASTER_SECRET = PushProperties.getProperty("getui.masterSecret");
    static String HOST = PushProperties.getProperty("getui.apiUrl", "http://sdk.open.api.igexin.com/apiex.htm");
    private String appId;
    private String appKey;
    private String masterSecret;

    public GePusher() {
        this.appId = APP_ID;
        this.appKey = APP_KEY;
        this.masterSecret = MASTER_SECRET;
    }

    public GePusher(String appId, String appKey, String masterSecret) {
        this.appId = appId;
        this.appKey = appKey;
        this.masterSecret = masterSecret;
    }

    @Override
    public void pushToAlias(String alias, PushBody pushBody) {
        ArrayList<Object> aliasList = new ArrayList<Object>();
        aliasList.add(alias);
        this.pushToAlias(aliasList, pushBody);
    }

    @Override
    public void pushToAlias(List<Object> alias, PushBody pushBody) {
        ArrayList<String> aliasList = new ArrayList<String>();
        for (Object o : alias) {
            aliasList.add(String.valueOf(o));
        }
        pushBody.setMsgId(UUID.randomUUID().toString());
        pushBody.setDate(System.currentTimeMillis());
        if (pushBody.getTitle() == null) {
            pushBody.setTitle("\u7cfb\u7edf\u901a\u77e5");
        }
        if (pushBody.getIcon() == null) {
            pushBody.setIcon(PushBody.PUSH_ICON);
        }
        if (pushBody.getExtra() == null) {
            pushBody.setExtra(new HashMap());
        }
        this.sendPushByAlias(aliasList, pushBody);
    }

    @Override
    public void sendPushByAlias(List<String> aliasList, PushBody pushBody) {
        NotificationTemplate template = this.buildNotificationTemplate(pushBody);
        for (String cid : aliasList) {
            this.pushMessageToSingle(cid, (ITemplate)template);
        }
    }

    @Override
    public void pushToTags(List<Object> tags, PushBody pushBody) {
        ArrayList<String> tagList = new ArrayList<String>();
        for (Object o : tags) {
            tagList.add(String.valueOf(o));
        }
        pushBody.setMsgId(UUID.randomUUID().toString());
        pushBody.setDate(System.currentTimeMillis());
        if (pushBody.getTitle() == null) {
            pushBody.setTitle("\u7cfb\u7edf\u901a\u77e5");
        }
        if (pushBody.getIcon() == null) {
            pushBody.setIcon(PushBody.PUSH_ICON);
        }
        if (pushBody.getExtra() == null) {
            pushBody.setExtra(new HashMap());
        }
        this.sendPushByTags(tagList, pushBody);
    }

    @Override
    public void sendPushByTags(List<String> tags, PushBody pushBody) {
    }

    @Override
    public void notification(PushBody pushBody) {
        NotificationTemplate template = this.buildNotificationTemplate(pushBody);
        this.pushMessageToApp((ITemplate)template);
    }

    public NotificationTemplate buildNotificationTemplate(PushBody pushBody) {
        NotificationTemplate template = new NotificationTemplate();
        template.setAppId(this.appId);
        template.setAppkey(this.appKey);
        Style0 style = new Style0();
        style.setTitle(pushBody.getTitle());
        style.setText(pushBody.getContent());
        style.setLogo(pushBody.getIcon());
        style.setLogoUrl("");
        style.setRing(true);
        style.setVibrate(true);
        style.setClearable(true);
        template.setStyle((AbstractNotifyStyle)style);
        template.setTransmissionContent(pushBody.toString());
        return template;
    }

    public LinkTemplate buildLinkTemplate(PushBody pushBody) {
        LinkTemplate template = new LinkTemplate();
        template.setAppId(this.appId);
        template.setAppkey(this.appKey);
        Style0 style = new Style0();
        style.setTitle(pushBody.getTitle());
        style.setText(pushBody.getContent());
        style.setLogo(pushBody.getIcon());
        style.setLogoUrl("");
        style.setRing(true);
        style.setVibrate(true);
        style.setClearable(true);
        template.setStyle((AbstractNotifyStyle)style);
        template.setUrl(pushBody.getLink());
        return template;
    }

    public TransmissionTemplate buildTransmissionTemplate(PushBody pushBody) {
        TransmissionTemplate template = new TransmissionTemplate();
        template.setAppId(this.appId);
        template.setAppkey(this.appKey);
        template.setTransmissionContent(pushBody.toString());
        template.setTransmissionType(2);
        APNPayload payload = new APNPayload();
        payload.setAutoBadge("+1");
        payload.setContentAvailable(1);
        payload.addCustomMsg("payload", (Object)pushBody.toString());
        payload.setAlertMsg((APNPayload.AlertMsg)new APNPayload.SimpleAlertMsg(pushBody.getTitle()));
        payload.setAlertMsg((APNPayload.AlertMsg)GePusher.getDictionaryAlertMsg(pushBody));
        payload.setVoicePlayType(0);
        payload.setVoicePlayMessage(pushBody.getTitle());
        template.setAPNInfo((Payload)payload);
        return template;
    }

    private static APNPayload.DictionaryAlertMsg getDictionaryAlertMsg(PushBody pushBody) {
        APNPayload.DictionaryAlertMsg alertMsg = new APNPayload.DictionaryAlertMsg();
        alertMsg.setBody(pushBody.getContent());
        alertMsg.setActionLocKey("ActionLockey");
        alertMsg.setLocKey("LocKey");
        alertMsg.addLocArg("loc-args");
        alertMsg.setLaunchImage("launch-image");
        alertMsg.setTitle(pushBody.getTitle());
        alertMsg.setTitleLocKey("TitleLocKey");
        alertMsg.addTitleLocArg("TitleLocArg");
        return alertMsg;
    }

    private void pushMessageToSingle(String cid, ITemplate template) {
        IGtPush push = new IGtPush(HOST, this.appKey, this.masterSecret);
        SingleMessage message = new SingleMessage();
        template.getPushInfo();
        message.setOffline(true);
        message.setOfflineExpireTime(86400000L);
        message.setData(template);
        message.setPushNetWorkType(0);
        Target target = new Target();
        target.setAppId(this.appId);
        target.setClientId(cid);
        IPushResult ret = null;
        try {
            ret = push.pushMessageToSingle(message, target);
        }
        catch (RequestException e) {
            e.printStackTrace();
            ret = push.pushMessageToSingle(message, target, e.getRequestId());
        }
        if (ret != null) {
            System.out.println(ret.getResponse().toString());
        } else {
            System.out.println("\u670d\u52a1\u5668\u54cd\u5e94\u5f02\u5e38");
        }
    }

    private void pushMessageToApp(ITemplate template) {
        IGtPush push = new IGtPush(HOST, this.appKey, this.masterSecret);
        AppMessage message = new AppMessage();
        message.setData(template);
        message.setOffline(true);
        message.setOfflineExpireTime(86400000L);
        AppConditions cdt = new AppConditions();
        ArrayList<String> appIdList = new ArrayList<String>();
        appIdList.add(this.appId);
        message.setAppIdList(appIdList);
        ArrayList phoneTypeList = new ArrayList();
        ArrayList provinceList = new ArrayList();
        ArrayList tagList = new ArrayList();
        cdt.addCondition("phoneType", phoneTypeList);
        cdt.addCondition("region", provinceList);
        cdt.addCondition("tag", tagList);
        message.setConditions(cdt);
        IPushResult ret = push.pushMessageToApp(message);
        System.out.println(ret.getResponse().toString());
    }
}

