/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.push.common;

import cn.jpush.api.JPushClient;
import cn.jpush.api.common.resp.APIConnectionException;
import cn.jpush.api.common.resp.APIRequestException;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.Message;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import com.crawler.push.bean.PushBody;
import com.crawler.push.common.Pushable;
import com.crawler.push.config.PushProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPusher
implements Pushable {
    protected static final Logger LOG = LoggerFactory.getLogger(JPusher.class);
    private static final String APP_KEY = PushProperties.getProperty("jpush.appKey");
    private static final String MASTER_SECRET = PushProperties.getProperty("jpush.masterSecret");
    private String appKey;
    private String masterSecret;

    public JPusher() {
        this.appKey = APP_KEY;
        this.masterSecret = MASTER_SECRET;
    }

    public JPusher(String appKey, String masterSecret) {
        this.appKey = appKey;
        this.masterSecret = masterSecret;
    }

    @Override
    public void pushToAlias(String alias, PushBody pushBody) {
        ArrayList<Object> aliasList = new ArrayList<Object>();
        aliasList.add(alias);
        this.pushToAlias(aliasList, pushBody);
    }

    @Override
    public void pushToAlias(List<Object> alias, PushBody pushBody) {
        ArrayList<String> aliasList = new ArrayList<String>();
        for (Object o : alias) {
            aliasList.add(String.valueOf(o));
        }
        pushBody.setMsgId(UUID.randomUUID().toString());
        pushBody.setDate(System.currentTimeMillis());
        if (pushBody.getTitle() == null) {
            pushBody.setTitle("\u7cfb\u7edf\u901a\u77e5");
        }
        if (pushBody.getIcon() == null) {
            pushBody.setIcon(PushBody.PUSH_ICON);
        }
        if (pushBody.getExtra() == null) {
            pushBody.setExtra(new HashMap());
        }
        this.sendPushByAlias(aliasList, pushBody);
    }

    @Override
    public void sendPushByAlias(List<String> aliasList, PushBody pushBody) {
        JPushClient jpushClient = new JPushClient(this.masterSecret, this.appKey, 5);
        PushPayload payload = this.buildPushObjectByAlias(aliasList, pushBody.toString());
        try {
            PushResult result = jpushClient.sendPush(payload);
            LOG.info("Got result - " + result);
        }
        catch (APIConnectionException e) {
            LOG.error("Connection error. Should retry later. ", (Throwable)e);
        }
        catch (APIRequestException e) {
            LOG.error("Error response from JPush server. Should review and fix it. ", (Throwable)e);
            LOG.info("HTTP Status: " + e.getStatus());
            LOG.info("Error Code: " + e.getErrorCode());
            LOG.info("Error Message: " + e.getErrorMessage());
            LOG.info("Msg ID: " + e.getMsgId());
        }
    }

    @Override
    public void pushToTags(List<Object> tags, PushBody pushBody) {
        ArrayList<String> tagList = new ArrayList<String>();
        for (Object o : tags) {
            tagList.add(String.valueOf(o));
        }
        pushBody.setMsgId(UUID.randomUUID().toString());
        pushBody.setDate(System.currentTimeMillis());
        if (pushBody.getTitle() == null) {
            pushBody.setTitle("\u7cfb\u7edf\u901a\u77e5");
        }
        if (pushBody.getIcon() == null) {
            pushBody.setIcon(PushBody.PUSH_ICON);
        }
        if (pushBody.getExtra() == null) {
            pushBody.setExtra(new HashMap());
        }
        this.sendPushByTags(tagList, pushBody);
    }

    @Override
    public void sendPushByTags(List<String> tags, PushBody pushBody) {
        JPushClient jpushClient = new JPushClient(this.masterSecret, this.appKey, 5);
        PushPayload payload = this.buildPushObjectByAlias(tags, pushBody.toString());
        try {
            PushResult result = jpushClient.sendPush(payload);
            LOG.info("Got result - " + result);
        }
        catch (APIConnectionException e) {
            LOG.error("Connection error. Should retry later. ", (Throwable)e);
        }
        catch (APIRequestException e) {
            LOG.error("Error response from JPush server. Should review and fix it. ", (Throwable)e);
            LOG.info("HTTP Status: " + e.getStatus());
            LOG.info("Error Code: " + e.getErrorCode());
            LOG.info("Error Message: " + e.getErrorMessage());
            LOG.info("Msg ID: " + e.getMsgId());
        }
    }

    @Override
    public void notification(PushBody pushBody) {
        JPushClient jpushClient = new JPushClient(this.masterSecret, this.appKey, 5);
        PushPayload payload = this.bulidNotification(pushBody.toString());
        try {
            PushResult result = jpushClient.sendPush(payload);
            LOG.info("Got result - " + result);
        }
        catch (APIConnectionException e) {
            LOG.error("Connection error. Should retry later. ", (Throwable)e);
        }
        catch (APIRequestException e) {
            LOG.error("Error response from JPush server. Should review and fix it. ", (Throwable)e);
            LOG.info("HTTP Status: " + e.getStatus());
            LOG.info("Error Code: " + e.getErrorCode());
            LOG.info("Error Message: " + e.getErrorMessage());
            LOG.info("Msg ID: " + e.getMsgId());
        }
    }

    private PushPayload buildPushObjectByAlias(List<String> alias, String msgContent) {
        return PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.alias(alias)).setMessage(Message.content((String)msgContent)).build();
    }

    private PushPayload buildPushObjectByTags(List<String> tags, String msgContent) {
        return PushPayload.newBuilder().setPlatform(Platform.android_ios()).setAudience(Audience.tag(tags)).setMessage(Message.content((String)msgContent)).build();
    }

    private PushPayload bulidNotification(String msgContent) {
        return PushPayload.newBuilder().setPlatform(Platform.android_ios()).setAudience(Audience.all()).setMessage(Message.newBuilder().setMsgContent(msgContent).build()).build();
    }
}

