/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.push.common;

import com.crawler.push.bean.MsgItem;
import com.crawler.push.bean.PushBody;
import com.crawler.push.common.GePusher;
import com.crawler.push.common.JPusher;
import com.crawler.push.common.Pushable;
import com.crawler.push.config.PushProperties;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pusher {
    private static final Logger LOGGER = LoggerFactory.getLogger(Pusher.class);
    public static final String MODE = PushProperties.getProperty("push.mode");
    public static final String MODE_GETUI = "getui";
    public static final String MOdE_JPUSH = "jpush";
    public static final int MSG_TYPE_OTHERS = 0;

    public static void pushToAlias(final PushBody msg, final Object ... targetUserIds) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.currentThread();
                    Thread.sleep(300L);
                    Integer msgType = msg.getType();
                    if (msgType == null) {
                        msgType = 0;
                        msg.setType(msgType);
                    }
                    if (msg.getDeletable() == null) {
                        msg.setDeletable(1);
                    }
                    List<Object> alias = Arrays.asList(targetUserIds);
                    Pushable pushable = Pusher.getPushable();
                    pushable.pushToAlias(alias, msg);
                }
                catch (InterruptedException ex) {
                    LOGGER.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }){}.start();
    }

    public static void pushByTags(final PushBody msg, final Object ... targetTags) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.currentThread();
                    Thread.sleep(300L);
                    Integer msgType = msg.getType();
                    if (msgType == null) {
                        msgType = 0;
                        msg.setType(msgType);
                    }
                    if (msg.getDeletable() == null) {
                        msg.setDeletable(1);
                    }
                    List<Object> tags = Arrays.asList(targetTags);
                    Pushable pushable = Pusher.getPushable();
                    pushable.pushToTags(tags, msg);
                }
                catch (InterruptedException ex) {
                    LOGGER.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }){}.start();
    }

    public static void pushNotification(final PushBody msg) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.currentThread();
                    Thread.sleep(300L);
                    Integer msgType = msg.getType();
                    if (msgType == null) {
                        msgType = 0;
                        msg.setType(msgType);
                    }
                    if (msg.getDeletable() == null) {
                        msg.setDeletable(1);
                    }
                    Pushable pushable = Pusher.getPushable();
                    pushable.notification(msg);
                }
                catch (InterruptedException ex) {
                    LOGGER.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }){}.start();
    }

    public static void send(PushBody msg, Object ... targets) {
        Pusher.pushToAlias(msg, targets);
    }

    public static void batchSend(List<MsgItem> msgItems) {
        for (MsgItem msgItem : msgItems) {
            Pusher.pushToAlias(msgItem.getMsg(), msgItem.getTargetId());
        }
    }

    public static void mass(PushBody msg, Object ... targetTags) {
        Pusher.pushByTags(msg, targetTags);
    }

    public static void notification(PushBody msg) {
        Pusher.pushNotification(msg);
    }

    public static Pushable getPushable() {
        if (MODE_GETUI.equals(MODE)) {
            return new GePusher();
        }
        return new JPusher();
    }

    public static boolean useCid() {
        return MODE_GETUI.equals(MODE);
    }
}

