package com.crawler.redis.vo;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;


/**
 * 分页类
 * @author rubekid
 *
 * @param <T>
 */
public class RedisPage<T>{
	
	/**
	 * 默认分页大小
	 */
	public static final int PAGE_SIZE = 10;
	
	/**
	 * 数据列表
	 */
	private List<T> items = new ArrayList<T>();
	
	/**
	 * 总记录数
	 */
	private long totalCount = 0;
	
	/**
	 * 当前页面
	 */
	protected int pageNo = 1;
	
	/**
	 * 分页大小
	 */
	protected int pageSize = 1;

	public RedisPage() {
		setPageSize(PAGE_SIZE);
	}
	
	public RedisPage(Integer pageSize, Integer pageNo){
		setPageSize(pageSize);
		setPageNo(pageNo);
	}

	public int getPageNo() {
		return pageNo;
	}

	public void setPageNo(int pageNo) {
		this.pageNo = pageNo;
	}

	public int getPageSize() {
		return pageSize;
	}

	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}

	public List<T> getItems() {
		return items;
	}


	public void setItems(List<T> items) {
		this.items = items;
	}

	public long getTotalCount() {
		return this.totalCount;
	}

	public void setTotalCount(long totalCount) {
		this.totalCount = totalCount;
	}

	public long getTotalPages() {
		long count = totalCount / pageSize;
		if (totalCount % pageSize > 0){
			count ++;
		}
		return count;
	}
	
	@JsonIgnore
	public int getFirst() {
		int first = 0;
		if ((this.pageNo > 0 &&  this.pageSize > 0)){
			first = ((this.pageNo - 1) * this.pageSize);
		}
		return first;
	}

}