package com.crawler.res.common;

import java.io.InputStream;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 系统配置
 * @author rubekid
 * @date 2016年7月16日
 */
public class ResProperties {
	
	private static final Logger logger = LoggerFactory.getLogger(ResProperties.class);
	
	private static Properties properties;
	
	static {
        try {
        	properties = new Properties();
            InputStream stream = ResProperties.class.getClassLoader().getResourceAsStream("config.properties");
            if (stream != null) {
                properties.load(stream);
            }
            
        } catch (Exception ex) {
            logger.warn("Read config.properties error.", ex);
        }
    }

	public static Properties getProperties() {
		return properties;
	}


    public static String getProperty(String key, String defaultValue) {
        return properties.getProperty(key, defaultValue);
    }
    
    public static int getPropertyForInteger(String key, String defaultValue) {
        String value = getProperty(key, defaultValue);
        try {
            return Integer.parseInt(value);
        } catch (Exception ex) {
            throw new IllegalArgumentException("转换 \"" + value + "\" 为 int 过程发生错误，引发的 properties 属性为 " + key);
        }
    }
    
    public static boolean getPropertyForBoolean(String key, String defaultValue) {
        String value = getProperty(key, defaultValue);
        try {
            return Boolean.parseBoolean(value);
        } catch (Exception ex) {
            throw new IllegalArgumentException("转换 \"" + value + "\" 为 boolean 过程发生错误，引发的 properties 属性为 " + key);
        }
    }

}
