package com.crawler.res.common;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.baidu.ueditor.ActionEnter;
import com.crawler.res.qiniu.QiniuClient;

/**
 * 百度编辑器基类
 * @author Rubekid
 *
 * 2017年4月16日 下午2:55:24
 */
public abstract class UeditorBaseController {
	
	@RequestMapping(method = RequestMethod.GET)
	public void get(HttpServletRequest request, HttpServletResponse response) throws IOException{
		doAction(request, response);
	}
	
	@RequestMapping(method = RequestMethod.POST)
	public void post(HttpServletRequest request, HttpServletResponse response) throws IOException{
		doAction(request, response);
	}
	
	/**
	 * 获取根目录
	 * @return
	 */
	protected abstract String getRootPath();
	
	/**
	 * 配置文件路径
	 * @return
	 */
	protected abstract String getConfigPath();
	
	private void doAction(HttpServletRequest request, HttpServletResponse response) throws IOException{
		PrintWriter out = response.getWriter();
		response.setHeader("Content-Type", "text/html");
		out.write( new ActionEnter( request, getRootPath(), getConfigPath(), getQiniuClient()).exec() );
		
	}
	

	/**
	 * 获取七牛云Client
	 * @return
	 */
	protected QiniuClient getQiniuClient() {
		
		return null;
	} 
	

}
