package com.crawler.res.qiniu;

/**
 * 七牛云配置
 * @author rubekid
 *
 * 2018年3月8日 下午1:29:49
 */
public class QiniuConfig {

	/**
	 * 绑定域名
	 */
	private String domain;
	
	/**
	 * Access Key
	 */
	private String accessKey;
	
	/**
	 * Secret Key
	 */
	private String secretKey;
	
	/**
	 * 空间
	 */
	private String bucketName;
	
	/**
	 * 区域
	 * 华东	Zone.zone0()
	 * 华北	Zone.zone1()
	 * 华南	Zone.zone2()
	 * 北美	Zone.zoneNa0()
	 */
	private String zone;
	
	public QiniuConfig() {
	}
	
	public QiniuConfig(String domain, String accessKey, String secretKey, String bucketName, String zone){
		this.domain = domain;
		this.accessKey = accessKey;
		this.secretKey = secretKey;
		this.bucketName = bucketName;
		this.zone = zone;
	}

	public String getDomain() {
		return domain;
	}

	public String getAccessKey() {
		return accessKey;
	}

	public String getSecretKey() {
		return secretKey;
	}

	public String getBucketName() {
		return bucketName;
	}

	public String getZone() {
		return zone;
	}

	public void setDomain(String domain) {
		this.domain = domain;
	}

	public void setAccessKey(String accessKey) {
		this.accessKey = accessKey;
	}

	public void setSecretKey(String secretKey) {
		this.secretKey = secretKey;
	}

	public void setBucketName(String bucketName) {
		this.bucketName = bucketName;
	}

	public void setZone(String zone) {
		this.zone = zone;
	}
	
	
}
