package com.crawler.res.utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

import org.apache.commons.codec.binary.Hex;

/**
 * 文件工具类
 * @author rubekid
 *
 * 2018年2月22日 上午10:40:29
 */
public class FileUtils {

	/**
	 * 获取名称
	 * @return
	 */
	public static String createFileName(){
		String md5 = md5(UUID.randomUUID().toString(), System.currentTimeMillis());
		return md5.substring(8, 24);
	}
	
	/**
	 * 16Md5
	 * @param message
	 * @param salt
	 * @return
	 */
	public static String shortMd5(String message, String salt){
		String md5 = md5(message, salt);
		return md5.substring(8, 24);
	}
	
	/**
	 * 生成MD5
	 * @param message
	 * @return
	 */
	public static String md5(String message, Object salt){
		try{
			MessageDigest messageDigest = MessageDigest.getInstance("MD5");
			if (salt != null && !"".equals(salt)) {
				message =  message + "{" + salt.toString() + "}";
			}
			byte[] digest = messageDigest.digest(message.getBytes("utf-8"));
			return Hex.encodeHexString(digest);
		}
		catch(NoSuchAlgorithmException | UnsupportedEncodingException ex){}
		
		return String.valueOf(System.currentTimeMillis());
	}
}
