/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor.upload;

import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.FileType;
import com.baidu.ueditor.define.State;
import com.crawler.res.utils.QiNiuUtils;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;

public final class Base64Uploader {
    public static State save(String content, Map<String, Object> conf) {
        long maxSize;
        byte[] data = Base64Uploader.decode(content);
        if (!Base64Uploader.validSize(data, maxSize = ((Long)conf.get("maxSize")).longValue())) {
            return new BaseState(false, 1);
        }
        String suffix = FileType.getSuffix("JPG");
        try {
            String fileName = UUID.randomUUID() + suffix;
            QiNiuUtils.upload(data, fileName);
            String url = String.valueOf(QiNiuUtils.DOMAIN) + "/" + fileName;
            BaseState storageState = new BaseState(true);
            if (storageState.isSuccess()) {
                storageState.putInfo("size", content.length());
                storageState.putInfo("title", (String)conf.get("filename"));
                storageState.putInfo("url", url);
                storageState.putInfo("type", suffix);
                storageState.putInfo("original", "");
            }
            return storageState;
        }
        catch (RuntimeException ex) {
            return new BaseState(false, 4);
        }
    }

    private static byte[] decode(String content) {
        return Base64.decodeBase64((String)content);
    }

    private static boolean validSize(byte[] data, long length) {
        return (long)data.length <= length;
    }
}

