/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor.upload;

import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.FileType;
import com.baidu.ueditor.define.State;
import com.crawler.res.utils.QiNiuUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class BinaryUploader {
    public static final State save(HttpServletRequest request, Map<String, Object> conf) {
        boolean isAjaxUpload;
        boolean bl = isAjaxUpload = request.getHeader("X_Requested_With") != null;
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            return new BaseState(false, 5);
        }
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        if (isAjaxUpload) {
            upload.setHeaderEncoding("UTF-8");
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        MultiValueMap map = multipartRequest.getMultiFileMap();
        CommonsMultipartFile multipartFile = null;
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue() == null || ((List)entry.getValue()).size() <= 0) continue;
            multipartFile = (CommonsMultipartFile)((List)entry.getValue()).get(0);
            break;
        }
        if (multipartFile == null) {
            return new BaseState(false, 7);
        }
        String originFileName = multipartFile.getFileItem().getName();
        String suffix = FileType.getSuffixByFilename(originFileName);
        originFileName = originFileName.substring(0, originFileName.length() - suffix.length());
        if (!BinaryUploader.validType(suffix, (String[])conf.get("allowFiles"))) {
            return new BaseState(false, 8);
        }
        try {
            String fileName = UUID.randomUUID() + suffix;
            QiNiuUtils.upload(multipartFile.getBytes(), fileName);
            String url = String.valueOf(QiNiuUtils.DOMAIN) + "/" + fileName;
            BaseState storageState = new BaseState(true);
            if (storageState.isSuccess()) {
                storageState.putInfo("size", multipartFile.getSize());
                storageState.putInfo("title", originFileName);
                storageState.putInfo("url", url);
                storageState.putInfo("type", suffix);
                storageState.putInfo("original", String.valueOf(originFileName) + suffix);
            }
            return storageState;
        }
        catch (RuntimeException ex) {
            return new BaseState(false, 4);
        }
    }

    private static boolean validType(String type, String[] allowTypes) {
        List<String> list = Arrays.asList(allowTypes);
        return list.contains(type);
    }
}

