/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.res.common;

import com.crawler.res.utils.QiNiuUtils;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public abstract class UploaderBaseController {
    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, headers={"content-type=multipart/form-data"})
    public JSONObject upload(@RequestParam(value="files") CommonsMultipartFile multipartFile) throws IOException {
        return this.doUpload(multipartFile);
    }

    @ResponseBody
    @RequestMapping(value={"/image"}, method={RequestMethod.POST}, headers={"content-type=multipart/form-data"})
    public JSONObject imageUpload(@RequestParam(value="image") CommonsMultipartFile multipartFile) throws IOException {
        return this.doUpload(multipartFile);
    }

    @ResponseBody
    @RequestMapping(value={"/video"}, method={RequestMethod.POST}, headers={"content-type=multipart/form-data"})
    public JSONObject videoUpload(@RequestParam(value="video") CommonsMultipartFile multipartFile) throws IOException {
        String oFileName = multipartFile.getOriginalFilename();
        String ext = ".tmp";
        if (oFileName.contains(".")) {
            ext = oFileName.substring(oFileName.lastIndexOf("."));
        }
        String baseFileName = UUID.randomUUID().toString();
        String fileName = String.valueOf(baseFileName) + ext;
        String newFileName = String.valueOf(baseFileName) + ".mp4";
        JSONObject result = new JSONObject();
        if (!newFileName.equals(fileName)) {
            fileName = "tmp/" + fileName;
            QiNiuUtils.upload(multipartFile.getBytes(), fileName);
            String persistentId = QiNiuUtils.toMp4(fileName, newFileName);
            result.put((Object)"persistentId", (Object)persistentId);
        } else {
            QiNiuUtils.upload(multipartFile.getBytes(), newFileName);
        }
        result.put((Object)"url", (Object)(String.valueOf(QiNiuUtils.DOMAIN) + "/" + newFileName));
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"/video/query/status/{persistentId:.+}"}, method={RequestMethod.GET})
    public JSONObject queryVideoStatus(@PathVariable(value="persistentId") String persistentId) throws QiniuException {
        Client client = new Client();
        return JSONObject.fromObject((Object)client.get("http://api.qiniu.com/status/get/prefop?id=" + persistentId).bodyString());
    }

    @ResponseBody
    @RequestMapping(value={"/images"}, method={RequestMethod.POST}, headers={"content-type=multipart/form-data"})
    public JSONArray batchImageUpload(@RequestParam(value="images", required=false) List<CommonsMultipartFile> multipartFiles1, @RequestParam(value="images[]", required=false) List<CommonsMultipartFile> multipartFiles2) throws IOException {
        List<CommonsMultipartFile> multipartFiles = multipartFiles1 == null ? multipartFiles2 : multipartFiles1;
        JSONArray items = new JSONArray();
        for (CommonsMultipartFile multipartFile : multipartFiles) {
            items.add((Object)this.doUpload(multipartFile));
        }
        return items;
    }

    protected JSONObject doUpload(CommonsMultipartFile multipartFile) throws IOException {
        String oFileName = multipartFile.getOriginalFilename();
        String ext = ".tmp";
        if (oFileName.contains(".")) {
            ext = oFileName.substring(oFileName.lastIndexOf("."));
        }
        String fileName = UUID.randomUUID() + ext;
        QiNiuUtils.upload(multipartFile.getBytes(), fileName);
        JSONObject result = new JSONObject();
        result.put((Object)"url", (Object)(String.valueOf(QiNiuUtils.DOMAIN) + "/" + fileName));
        return result;
    }
}

