/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.res.utils;

import com.crawler.res.common.QiniuProperties;
import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.processing.OperationManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import com.qiniu.util.UrlSafeBase64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.UUID;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QiNiuUtils {
    private static final Logger logger = LoggerFactory.getLogger(QiNiuUtils.class);
    public static final String DOMAIN = QiniuProperties.getProperty("qiniu.domain");
    private static final String ACCESS_KEY = QiniuProperties.getProperty("qiniu.access_key");
    private static final String SECRET_KEY = QiniuProperties.getProperty("qiniu.secret_key");
    private static final String BUCKET_NAME = QiniuProperties.getProperty("qiniu.bucket");
    private static final String ZONE = QiniuProperties.getProperty("qiniu.zone");
    private static final String PIPELINE = QiniuProperties.getProperty("qiniu.pipeline", "admin_merge_radio");
    private static final Auth auth = Auth.create((String)ACCESS_KEY, (String)SECRET_KEY);
    private static final Configuration cfg;

    static {
        Zone zone = Zone.autoZone();
        if ("zone0".equals(ZONE)) {
            zone = Zone.zone0();
        } else if ("zone1".equals(ZONE)) {
            zone = Zone.zone1();
        } else if ("zone2".equals(ZONE)) {
            zone = Zone.zone2();
        } else if ("zoneNa0".equals(ZONE)) {
            zone = Zone.zoneNa0();
        }
        cfg = new Configuration(zone);
    }

    public static String getUpToken() {
        return auth.uploadToken(BUCKET_NAME, null, 360000L, null, true);
    }

    public static String getUpToken(String buketName) {
        return auth.uploadToken(buketName, null, 360000L, null, true);
    }

    public static void upload(byte[] data, String fileName) {
        try {
            UploadManager uploadManager = new UploadManager(cfg);
            Response res = uploadManager.put(data, fileName, QiNiuUtils.getUpToken());
            logger.info("\u4e0a\u4f20\u54cd\u5e94\u4fe1\u606f\uff1a" + res.bodyString());
        }
        catch (QiniuException e) {
            Response r = e.response;
            System.out.println(r.toString());
            throw new RuntimeException("\u4e0a\u4f20\u5931\u8d25");
        }
    }

    public static JSONObject imageInfo(String url) {
        JSONObject result = new JSONObject();
        try {
            Client client = new Client();
            Response response = client.get(String.valueOf(url) + "?imageInfo");
            return JSONObject.fromObject((Object)response.bodyString());
        }
        catch (QiniuException e) {
            e.printStackTrace();
            return result;
        }
    }

    public static String transfer(String url, String fileName) throws IOException {
        byte[] types;
        if (fileName == null) {
            fileName = UUID.randomUUID() + url.substring(url.lastIndexOf("."));
        }
        if ((types = QiNiuUtils.toByte(url)) == null) {
            return null;
        }
        QiNiuUtils.upload(types, fileName);
        return String.valueOf(DOMAIN) + "/" + fileName;
    }

    public static String transfer(String url) throws IOException {
        return QiNiuUtils.transfer(url, null);
    }

    private static byte[] toByte(String urlString) {
        try {
            URL url = new URL(urlString);
            URLConnection con = url.openConnection();
            con.setConnectTimeout(5000);
            InputStream is = con.getInputStream();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = is.read(buffer))) {
                output.write(buffer, 0, n);
            }
            is.close();
            return output.toByteArray();
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static String toMp4(String fileName, String newFileName) throws QiniuException {
        String pipeline = PIPELINE;
        String saveAs = UrlSafeBase64.encodeToString((String)(String.valueOf(BUCKET_NAME) + ":" + newFileName));
        String fops = "avthumb/mp4/vcodec/libx264|saveas/" + saveAs;
        OperationManager operationMgr = new OperationManager(auth, cfg);
        String persistentId = operationMgr.pfop(BUCKET_NAME, fileName, fops, new StringMap().put("persistentPipeline", (Object)pipeline));
        return persistentId;
    }

    public static void main(String[] args) {
        QiNiuUtils.imageInfo("http://or84r4lrb.bkt.clouddn.com/242b7b54-affc-4f72-b662-136c41b503a4.jpg");
    }
}

