/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.client.auth;

import com.crawler.RestProperties;
import com.crawler.client.auth.RestBearerTokenService;
import com.crawler.client.entity.RestBearerToken;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class RestBearerTokenProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestBearerTokenProvider.class);
    public static final String CLIENT_MIN_REFRESH_SPAN = "client.minRefreshSpan";
    private static final String CLIENT_MIN_REFRESH_SPAN_VALUE = "300000";
    private RestBearerToken bearerToken;
    private int minRefreshSpan;
    private RestBearerTokenService restBearerTokenService;

    public RestBearerTokenProvider(RestBearerTokenService restBearerTokenService) {
        this.restBearerTokenService = restBearerTokenService;
        this.minRefreshSpan = RestProperties.getPropertyForInteger(CLIENT_MIN_REFRESH_SPAN, CLIENT_MIN_REFRESH_SPAN_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestBearerToken getToken() {
        RestBearerTokenProvider restBearerTokenProvider;
        if (this.bearerToken == null) {
            restBearerTokenProvider = this;
            synchronized (restBearerTokenProvider) {
                this.bearerToken = this.restBearerTokenService.getBearerToken();
            }
        }
        Assert.notNull((Object)this.bearerToken, (String)"bearerToken");
        if (this.shouldRefreshToken(this.bearerToken)) {
            restBearerTokenProvider = this;
            synchronized (restBearerTokenProvider) {
                try {
                    this.bearerToken = this.restBearerTokenService.refreshBearerToken(this.bearerToken);
                }
                catch (Exception ex) {
                    LOGGER.error("\u5237\u65b0BearerToken\u5931\u8d25\uff1a" + ex.getMessage());
                }
            }
            if (this.bearerToken == null) {
                restBearerTokenProvider = this;
                synchronized (restBearerTokenProvider) {
                    this.bearerToken = this.restBearerTokenService.getBearerToken();
                }
            }
        }
        return this.bearerToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setToken(RestBearerToken token) {
        Assert.notNull((Object)token, (String)"token");
        RestBearerTokenProvider restBearerTokenProvider = this;
        synchronized (restBearerTokenProvider) {
            this.bearerToken = token;
        }
    }

    public boolean isAuthorized() {
        return this.bearerToken != null && !this.bearerToken.isExpire();
    }

    protected boolean shouldRefreshToken(RestBearerToken bearerToken) {
        Assert.notNull((Object)bearerToken, (String)"bearerToken");
        Date now = new Date();
        return bearerToken.getExpiresAt().getTime() - now.getTime() < (long)this.minRefreshSpan;
    }
}

