/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.client.auth;

import com.crawler.RestProperties;
import com.crawler.client.auth.RestBearerTokenService;
import com.crawler.client.auth.UserCenterAccount;
import com.crawler.client.entity.RestBearerToken;
import com.crawler.client.http.RestHttpClient;
import com.crawler.util.UrlUtil;
import java.util.Date;
import org.springframework.web.client.RestClientException;

public class RestBearerTokenServiceImpl
implements RestBearerTokenService {
    public static final String UC_API_REFRESH_TOKEN = "uc.api.refresh_token";
    public static final String UC_API_POST_BEARER_TOKEN = "uc.api.post_bearer_token";
    public static final String CLIENT_BEARER_TOKEN_ACCOUNT_USERNAME = "client.bearerToken.account.username";
    public static final String CLIENT_BEARER_TOKEN_ACCOUNT_PASSWORD = "client.bearerToken.account.password";
    public static final String CLIENT_BEARER_TOKEN_ACCOUNT_APPID = "app.id";
    private static final String UC_API_REFRESH_TOKEN_VALUE = "bearer_token/refresh";
    private static final String UC_API_POST_BEARER_TOKEN_VALUE = "bearer_token";
    private static final String CLIENT_BEARER_TOKEN_ACCOUNT_USERNAME_VALUE = "bearer";
    private static final String CLIENT_BEARER_TOKEN_ACCOUNT_PASSWORD_VALUE = "7d1ee5f6f44e25ec9056db37eeac517c";
    private RestHttpClient httpClient = new RestHttpClient();

    public RestHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(RestHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public RestBearerToken getBearerToken() throws RestClientException {
        UserCenterAccount ucAccount;
        RestBearerToken restBearerToken = null;
        String uri = this.getPostBearerTokenUri();
        RestAccessToken accessToken = this.httpClient.postForObject(uri, (Object)(ucAccount = this.getUCAccount()), RestAccessToken.class, new Object[0]);
        if (accessToken != null) {
            restBearerToken = accessToken.toRestBearerToken();
        }
        return restBearerToken;
    }

    @Override
    public RestBearerToken refreshBearerToken(RestBearerToken restBearerToken) throws RestClientException {
        RestBearerToken refreshBearerToken = null;
        String uri = this.getRefreshTokenUri(restBearerToken.getRefreshToken());
        RestAccessToken accessToken = this.httpClient.getForObject(uri, RestAccessToken.class, new Object[0]);
        if (accessToken != null) {
            refreshBearerToken = accessToken.toRestBearerToken();
        }
        return refreshBearerToken;
    }

    private String getRefreshTokenUri(String refreshToken) {
        return String.valueOf(UrlUtil.combine(this.getProperty("uc.uri"), this.getProperty(UC_API_REFRESH_TOKEN, UC_API_REFRESH_TOKEN_VALUE))) + "/" + refreshToken;
    }

    private String getPostBearerTokenUri() {
        return UrlUtil.combine(this.getProperty("uc.uri"), this.getProperty(UC_API_POST_BEARER_TOKEN, UC_API_POST_BEARER_TOKEN_VALUE));
    }

    private UserCenterAccount getUCAccount() {
        return new UserCenterAccount(this.getProperty(CLIENT_BEARER_TOKEN_ACCOUNT_USERNAME, CLIENT_BEARER_TOKEN_ACCOUNT_USERNAME_VALUE), this.getProperty(CLIENT_BEARER_TOKEN_ACCOUNT_PASSWORD, CLIENT_BEARER_TOKEN_ACCOUNT_PASSWORD_VALUE), this.getProperty(CLIENT_BEARER_TOKEN_ACCOUNT_APPID));
    }

    private String getProperty(String key) {
        return RestProperties.getProperty(key);
    }

    private String getProperty(String key, String defaultValue) {
        return RestProperties.getProperty(key, defaultValue);
    }

    private static class RestAccessToken {
        private String userId;
        private String accessToken;
        private Date expiresAt;
        private String refreshToken;

        private RestAccessToken() {
        }

        public String getUserId() {
            return this.userId;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public Date getExpiresAt() {
            return this.expiresAt;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public RestBearerToken toRestBearerToken() {
            return new RestBearerToken(this.getUserId(), this.getAccessToken(), this.getRefreshToken(), this.getExpiresAt());
        }
    }
}

