/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.client.http;

import com.crawler.client.RestResourceAccessException;
import com.crawler.client.exception.ErrorMessage;
import com.crawler.client.http.RestClientHttpResponse;
import com.crawler.util.JsonMapper;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.DefaultResponseErrorHandler;

class RestApiErrorHandler
extends DefaultResponseErrorHandler {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    RestApiErrorHandler() {
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        HttpStatus statusCode;
        RestClientHttpResponse restResponse = (RestClientHttpResponse)response;
        ErrorMessage errorMessage = null;
        MultiValueMap headers = null;
        String responseText = IOUtils.toString((InputStream)restResponse.getBody(), (String)"UTF-8");
        try {
            errorMessage = JsonMapper.parse(responseText, ErrorMessage.class);
            restResponse.getHeaders();
            statusCode = restResponse.getStatusCode();
        }
        catch (IOException ex) {
            String msg = "\u5c06 REST api \"" + restResponse.getHttpMethod() + " " + restResponse.getUri() + "\" \u7684\u54cd\u5e94\u5185\u5bb9 \"" + responseText + "\" \u8f6c\u6362\u4e3a " + ErrorMessage.class.toString() + " \u53d1\u751f\u5f02\u5e38\u3002";
            this.log.error(msg, (Throwable)ex);
            throw new IOException(msg, ex);
        }
        this.log.info("Remote restapi response error. Response content: ", (Object)responseText);
        ResponseEntity responseEntity = new ResponseEntity((Object)errorMessage, headers, statusCode);
        throw new RestResourceAccessException((ResponseEntity<ErrorMessage>)responseEntity, restResponse.getHttpMethod(), restResponse.getUri());
    }
}

