/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.rest.security.services.impl;

import com.crawler.RestProperties;
import com.crawler.rest.exceptions.extendExceptions.RestSimpleException;
import com.crawler.rest.security.authens.UcUserToken;
import com.crawler.rest.security.authentication.mac.PreAuthenticatedMacTokenAuthentication;
import com.crawler.rest.security.services.impl.UserCenterMacTokenService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.util.Assert;

public class UserCenterMacTokenCacheService
extends UserCenterMacTokenService {
    private static LoadingCache<PreAuthenticatedMacTokenAuthentication, UcUserToken> macTokenCache;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String MAC_TOKEN_CACHE_EXPIRE = "macToken.cache.expire";
    public static final String MAC_TOKEN_CACHE_MAX_SIZE = "macToken.cache.maxSize";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMacCache() {
        if (macTokenCache == null) {
            UserCenterMacTokenCacheService userCenterMacTokenCacheService = this;
            synchronized (userCenterMacTokenCacheService) {
                if (macTokenCache == null) {
                    macTokenCache = CacheBuilder.newBuilder().maximumSize((long)RestProperties.getPropertyForInteger((String)MAC_TOKEN_CACHE_MAX_SIZE, (String)"10000")).expireAfterWrite((long)RestProperties.getPropertyForInteger((String)MAC_TOKEN_CACHE_EXPIRE, (String)"120"), TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<PreAuthenticatedMacTokenAuthentication, UcUserToken>(){

                        public UcUserToken load(PreAuthenticatedMacTokenAuthentication key) throws Exception {
                            return UserCenterMacTokenCacheService.this.invoke((Authentication)key);
                        }
                    });
                }
            }
        }
    }

    private UcUserToken invoke(Authentication preAuthenticatedAuthentication) {
        return super.verifyToken(preAuthenticatedAuthentication);
    }

    @Override
    public UcUserToken verifyToken(Authentication preAuthenticatedAuthentication) {
        Assert.notNull((Object)preAuthenticatedAuthentication, (String)"preAuthenticatedAuthentication");
        PreAuthenticatedMacTokenAuthentication authentication = (PreAuthenticatedMacTokenAuthentication)preAuthenticatedAuthentication;
        this.initMacCache();
        UcUserToken ucCheckToken = null;
        try {
            ucCheckToken = (UcUserToken)macTokenCache.get((Object)authentication);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        Assert.notNull((Object)ucCheckToken, (String)"ucCheckToken");
        return this.checkMac(ucCheckToken, authentication);
    }

    public UcUserToken checkMac(UcUserToken ucCheckToken, PreAuthenticatedMacTokenAuthentication authRequest) {
        Assert.notNull((Object)ucCheckToken, (String)"ucCheckToken");
        Assert.notNull((Object)authRequest, (String)"authRequest");
        StringBuilder sbRawMac = new StringBuilder();
        sbRawMac.append(authRequest.getNonce());
        sbRawMac.append("\n");
        sbRawMac.append(authRequest.getHttpMethod().toUpperCase());
        sbRawMac.append("\n");
        sbRawMac.append(authRequest.getRequestUri());
        sbRawMac.append("\n");
        sbRawMac.append(authRequest.getHost());
        sbRawMac.append("\n");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Mac key:" + authRequest.getMac());
        }
        String newMac = UserCenterMacTokenCacheService.encryptHMac256(sbRawMac.toString(), ucCheckToken.getMacKey());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("newMac:" + newMac);
        }
        if (!authRequest.getMac().equalsIgnoreCase(newMac)) {
            this.logger.error(String.valueOf(authRequest.getMac()) + ":" + sbRawMac.toString());
            throw new RestSimpleException("\u6388\u6743\u6821\u9a8c\u5931\u8d25");
        }
        return ucCheckToken;
    }

    public static String encryptHMac256(String content, String key) {
        Assert.notNull((Object)content, (String)"content");
        Assert.notNull((Object)key, (String)"key");
        SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(), "HmacSHA256");
        Mac mac = null;
        try {
            mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        byte[] digest = mac.doFinal(content.getBytes());
        return new String(Base64.encode((byte[])digest));
    }

    public static void main(String[] args) {
        StringBuilder sbRawMac = new StringBuilder();
        sbRawMac.append("1500889111286:27bd7515");
        sbRawMac.append("\n");
        sbRawMac.append("GET");
        sbRawMac.append("\n");
        sbRawMac.append("/cooperate/selectEngineer?name=%23");
        sbRawMac.append("\n");
        sbRawMac.append("server.nsfkj.com");
        sbRawMac.append("\n");
        String newMac = UserCenterMacTokenCacheService.encryptHMac256(sbRawMac.toString(), "FSX4e5WB0L");
        System.out.println(newMac);
    }
}

