/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.rest.testconfig;

import com.crawler.rest.security.authens.RestUserAuthentication;
import com.crawler.rest.security.authens.UserCenterUserDetails;
import com.crawler.rest.security.authentication.RestAuthenticationException;
import com.crawler.rest.security.services.impl.UserCenterUserDetailsService;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@RunWith(value=SpringJUnit4ClassRunner.class)
@WebAppConfiguration
public class BaseSpringJunit4Config {
    protected MockMvc mockMvc;
    @Autowired
    private WebApplicationContext webApplicationContext;
    protected String userId;

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Before
    public void setUp() {
        this.mockMvc = MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.webApplicationContext).build();
        RestUserAuthentication authentication = this.getPrincipal(this.getUserId());
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
    }

    protected RestUserAuthentication getPrincipal(String userId) {
        UserCenterUserDetailsService userCenterUserDetailsService = new UserCenterUserDetailsService();
        RestUserAuthentication authentication = new RestUserAuthentication(null);
        try {
            UserCenterUserDetails userCenterUserDetails = userCenterUserDetailsService.loadUserDetailsByUserId(userId);
            authentication.setDetails((Object)userCenterUserDetails);
        }
        catch (RuntimeException ex) {
            throw new RestAuthenticationException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u53d1\u751f\u5f02\u5e38 " + ex.getMessage(), (Throwable)ex);
        }
        return authentication;
    }
}

