/*
 * Decompiled with CFR 0.152.
 */
package com.belerweb.social.weixin.api;

import com.belerweb.social.API;
import com.belerweb.social.bean.Error;
import com.belerweb.social.bean.Result;
import com.belerweb.social.weixin.api.Weixin;
import com.belerweb.social.weixin.bean.GetFollowersResult;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.NameValuePair;

public class User
extends API {
    protected User(Weixin weixin) {
        super(weixin);
    }

    public Result<com.belerweb.social.weixin.bean.User> snsapiUserInfo(String accessToken, String openId) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.weixin.addParameter(params, "access_token", accessToken);
        this.weixin.addParameter(params, "openid", openId);
        String json = this.weixin.get("https://api.weixin.qq.com/sns/userinfo", params);
        return Result.parse(json, com.belerweb.social.weixin.bean.User.class);
    }

    public Result<com.belerweb.social.weixin.bean.User> userInfo(String accessToken, String openId) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.weixin.addParameter(params, "access_token", accessToken);
        this.weixin.addParameter(params, "openid", openId);
        String json = this.weixin.get("https://api.weixin.qq.com/cgi-bin/user/info", params);
        return Result.parse(json, com.belerweb.social.weixin.bean.User.class);
    }

    public Result<List<com.belerweb.social.weixin.bean.User>> getFollowUsers() {
        return this.getFollowUsers(this.weixin.getAccessToken().getToken());
    }

    public Result<List<com.belerweb.social.weixin.bean.User>> getFollowUsers(String accessToken) {
        ArrayList<com.belerweb.social.weixin.bean.User> users = new ArrayList<com.belerweb.social.weixin.bean.User>();
        Result<GetFollowersResult> followersResult = this.getFollowers(accessToken);
        if (followersResult.success()) {
            for (String openId : followersResult.getResult().getOpenIds()) {
                Result<com.belerweb.social.weixin.bean.User> userResult = this.userInfo(accessToken, openId);
                if (userResult.success()) {
                    users.add(userResult.getResult());
                    continue;
                }
                return new Result<Error>(userResult.getError());
            }
            return new Result<List<com.belerweb.social.weixin.bean.User>>((List<com.belerweb.social.weixin.bean.User>)users);
        }
        return new Result<Error>(followersResult.getError());
    }

    public Result<GetFollowersResult> getFollowers() {
        return this.getFollowers(this.weixin.getAccessToken().getToken());
    }

    public Result<GetFollowersResult> getFollowers(String accessToken) {
        GetFollowersResult result = new GetFollowersResult();
        ArrayList<String> openIds = new ArrayList<String>();
        Result<GetFollowersResult> followers = this.getFollowers(accessToken, null);
        while (followers.success()) {
            for (String openId : followers.getResult().getOpenIds()) {
                openIds.add(openId);
            }
            String nextOpenid = followers.getResult().getNextOpenid();
            if (StringUtils.isBlank((String)nextOpenid) || followers.getResult().getTotal().intValue() == openIds.size()) break;
            followers = this.getFollowers(accessToken, nextOpenid);
        }
        if (!followers.success()) {
            return new Result<Error>(followers.getError());
        }
        result.setTotal(openIds.size());
        result.setCount(openIds.size());
        result.setOpenIds(openIds);
        return new Result<GetFollowersResult>(result);
    }

    public Result<GetFollowersResult> getFollowers(String accessToken, String openId) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.weixin.addParameter(params, "access_token", accessToken);
        this.weixin.addNotNullParameter(params, "next_openid", openId);
        String json = this.weixin.get("https://api.weixin.qq.com/cgi-bin/user/get", params);
        return Result.parse(json, GetFollowersResult.class);
    }
}

