/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.social.config;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocialProperties {
    private static final Logger logger = LoggerFactory.getLogger(SocialProperties.class);
    private static Properties properties;

    public static Properties getProperties() {
        return properties;
    }

    public static String getProperty(String key) {
        return properties.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        return properties.getProperty(key, defaultValue);
    }

    public static void setProperty(String key, String value) {
        properties.setProperty(key, value);
    }

    public static int getPropertyForInteger(String key) {
        String value = SocialProperties.getProperty(key);
        try {
            return Integer.parseInt(value);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("\u8f6c\u6362 \"" + value + "\" \u4e3a int \u8fc7\u7a0b\u53d1\u751f\u9519\u8bef\uff0c\u5f15\u53d1\u7684 properties \u5c5e\u6027\u4e3a " + key);
        }
    }

    public static int getPropertyForInteger(String key, String defaultValue) {
        String value = SocialProperties.getProperty(key, defaultValue);
        try {
            return Integer.parseInt(value);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("\u8f6c\u6362 \"" + value + "\" \u4e3a int \u8fc7\u7a0b\u53d1\u751f\u9519\u8bef\uff0c\u5f15\u53d1\u7684 properties \u5c5e\u6027\u4e3a " + key);
        }
    }

    public static boolean getPropertyForBoolean(String key, String defaultValue) {
        String value = SocialProperties.getProperty(key, defaultValue);
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("\u8f6c\u6362 \"" + value + "\" \u4e3a boolean \u8fc7\u7a0b\u53d1\u751f\u9519\u8bef\uff0c\u5f15\u53d1\u7684 properties \u5c5e\u6027\u4e3a " + key);
        }
    }

    static {
        try {
            String fileName = "social.properties";
            properties = new Properties();
            String userDir = System.getProperty("user.dir");
            String configPath = userDir + File.separator + "config" + File.separator + fileName;
            File configFile = new File(configPath);
            if (configFile.exists()) {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(configFile));
                properties.load(in);
            } else {
                InputStream stream = SocialProperties.class.getClassLoader().getResourceAsStream(fileName);
                if (stream != null) {
                    properties.load(stream);
                } else {
                    logger.warn("Read social.properties error.");
                }
            }
        }
        catch (Exception ex) {
            logger.warn("Read social.properties error.", (Throwable)ex);
        }
    }
}

