/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.weixin.push;

import com.crawler.social.config.WeixinConstant;
import com.crawler.utils.http.SimpleHttpClient;
import com.crawler.weixin.push.SubscribeTemplate;
import com.crawler.weixin.utils.WeixinUtils;
import com.crawler.weixin.vo.AccessToken;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribeTask
implements Runnable {
    public static final Logger LOGGER = LoggerFactory.getLogger(SubscribeTask.class);
    private static final String PUSH_URL = "https://api.weixin.qq.com/cgi-bin/message/subscribe/send?access_token=%s";
    private String appId;
    private String appSecret;
    private SubscribeTemplate template;

    public SubscribeTask() {
        this.appId = WeixinConstant.WEAPP_APP_ID;
        this.appSecret = WeixinConstant.WEAPP_APP_SECRET;
    }

    public SubscribeTask(SubscribeTemplate template) {
        this.template = template;
    }

    public SubscribeTask(String appId, String appSecret, SubscribeTemplate template) {
        this.appId = appId;
        this.appSecret = appSecret;
        this.template = template;
    }

    @Override
    public void run() {
        try {
            AccessToken accessToken = WeixinUtils.getAccessToken(this.appId, this.appSecret);
            String url = String.format(PUSH_URL, accessToken.getAccessToken());
            String content = SimpleHttpClient.post(url, JSONObject.fromObject((Object)com.alibaba.fastjson.JSONObject.toJSON((Object)this.template)));
            LOGGER.info("\n=============================\nNOTIFY RESULT :{}", (Object)content);
        }
        catch (RuntimeException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public SubscribeTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(SubscribeTemplate template) {
        this.template = template;
    }
}

