/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.weixin.push;

import com.crawler.social.config.WeixinConstant;
import com.crawler.utils.http.SimpleHttpClient;
import com.crawler.weixin.push.Template;
import com.crawler.weixin.utils.WeixinUtils;
import com.crawler.weixin.vo.AccessToken;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplatePusher {
    private static final String PUSH_URL = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=%s";
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplatePusher.class);

    public static void send(Template template) {
        TemplatePusher.send(template, WeixinConstant.APP_ID, WeixinConstant.APP_SECRET);
    }

    public static void send(Template template, String appId, String appSecret) {
        try {
            com.alibaba.fastjson.JSONObject response;
            AccessToken accessToken = WeixinUtils.getAccessToken(appId, appSecret);
            String url = String.format(PUSH_URL, accessToken.getAccessToken());
            String content = SimpleHttpClient.post(url, JSONObject.fromObject((Object)com.alibaba.fastjson.JSONObject.toJSON((Object)template)));
            if (content.startsWith("{") && content.endsWith("}") && (response = com.alibaba.fastjson.JSONObject.parseObject((String)content)).getInteger("errcode") != 0) {
                LOGGER.error(content);
            }
        }
        catch (RuntimeException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

