/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.weixin.push;

import com.crawler.social.config.WeixinConstant;
import com.crawler.utils.http.SimpleHttpClient;
import com.crawler.weixin.push.WeappTemplate;
import com.crawler.weixin.utils.WeixinUtils;
import com.crawler.weixin.vo.AccessToken;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeappNotifyTask
implements Runnable {
    public static final Logger LOGGER = LoggerFactory.getLogger(WeappNotifyTask.class);
    private static final String PUSH_URL = "https://api.weixin.qq.com/cgi-bin/message/wxopen/template/send?access_token=%s";
    private String appId;
    private String appSecret;
    private WeappTemplate template;

    public WeappNotifyTask() {
        this.appId = WeixinConstant.WEAPP_APP_ID;
        this.appSecret = WeixinConstant.WEAPP_APP_SECRET;
    }

    public WeappNotifyTask(WeappTemplate template) {
        this.template = template;
    }

    public WeappNotifyTask(String appId, String appSecret, WeappTemplate template) {
        this.appId = appId;
        this.appSecret = appSecret;
        this.template = template;
    }

    @Override
    public void run() {
        try {
            AccessToken accessToken = WeixinUtils.getAccessToken(this.appId, this.appSecret);
            String url = String.format(PUSH_URL, accessToken.getAccessToken());
            String content = SimpleHttpClient.post(url, JSONObject.fromObject((Object)com.alibaba.fastjson.JSONObject.toJSON((Object)this.template)));
            LOGGER.info("\n=============================\nNOTIFY RESULT :{}", (Object)content);
        }
        catch (RuntimeException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public WeappTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(WeappTemplate template) {
        this.template = template;
    }
}

