/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.weixin.weapp.util;

import com.crawler.redis.utils.RedisManager;
import com.crawler.social.config.SocialProperties;
import com.crawler.social.utils.BeanUtils;
import com.crawler.utils.http.SimpleHttpClient;
import com.crawler.weixin.weapp.model.WeappData;
import com.crawler.weixin.weapp.model.WeappPhoneInfo;
import com.crawler.weixin.weapp.model.WeappSession;
import com.crawler.weixin.weapp.model.WeappUserInfo;
import com.crawler.weixin.weapp.util.AES;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeappUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(WeappUtil.class);
    public static final String APP_ID = SocialProperties.getProperty("wx.weapp.app_id", SocialProperties.getProperty("weapp.app_id"));
    public static final String APP_SECRET = SocialProperties.getProperty("wx.weapp.app_secret", SocialProperties.getProperty("weapp.app_secret"));
    public static final String SESSION_URL = "https://api.weixin.qq.com/sns/jscode2session?appid=%s&secret=%s&js_code=%s&grant_type=authorization_code";
    public static final String SESSION_CACHE_KEY_PREFIX = "weapp:session:";

    public static WeappSession getSessionByCode(String code) {
        return WeappUtil.getSessionByCode(APP_ID, APP_SECRET, code);
    }

    public static WeappSession getSessionByCode(String appId, String appSecret, String code) {
        String sessionId = code + "@" + appId;
        WeappSession session = WeappUtil.getSessionById(sessionId);
        if (session == null || session.getOpenid() == null) {
            String url = String.format(SESSION_URL, appId, appSecret, code);
            session = SimpleHttpClient.getForObject(url, WeappSession.class);
            if (session != null && session.getOpenid() != null) {
                session.setSessionId(sessionId);
                WeappUtil.create3rdSession(session);
            } else {
                LOGGER.error("\u83b7\u53d6Session \u5931\u8d25 : {}", (Object)BeanUtils.toJSONString(session));
            }
        }
        return session;
    }

    public static WeappSession getSessionById(String sessionId) {
        String key = WeappUtil.sessionKey(sessionId);
        return (WeappSession)RedisManager.get((String)key, WeappSession.class);
    }

    public static void create3rdSession(WeappSession session) {
        String sessionId;
        String string = sessionId = session.getSessionId() != null ? session.getSessionId() : RandomStringUtils.randomAlphanumeric((int)64);
        if (session != null) {
            session.setSessionId(sessionId);
            String key = WeappUtil.sessionKey(sessionId);
            RedisManager.set((String)key, (Object)session, (int)session.getExpiresIn());
        }
    }

    public static WeappUserInfo getUserInfo(WeappData userData, String sessionKey) {
        return WeappUtil.getUserInfo(APP_ID, userData, sessionKey);
    }

    public static WeappUserInfo getUserInfo(String appId, WeappData userData, String sessionKey) {
        try {
            String userInfo;
            WeappUserInfo userInfoVo;
            AES aes = new AES();
            byte[] resultByte = aes.decrypt(Base64.decodeBase64((String)userData.getEncryptedData()), Base64.decodeBase64((String)sessionKey), Base64.decodeBase64((String)userData.getIv()));
            if (null != resultByte && resultByte.length > 0 && (userInfoVo = (WeappUserInfo)JSONObject.toBean((JSONObject)JSONObject.fromObject((Object)(userInfo = new String(resultByte, "UTF-8"))), WeappUserInfo.class)).getWatermark().getAppid().equals(appId)) {
                return userInfoVo;
            }
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    public static WeappPhoneInfo getPhoneInfo(WeappData phoneData, String sessionKey) {
        return WeappUtil.decrypt(phoneData, sessionKey, WeappPhoneInfo.class);
    }

    public static <T> T decrypt(WeappData weappData, String sessionKey, Class<T> clazz) {
        JSONObject json = WeappUtil.decrypt(weappData, sessionKey);
        if (json != null) {
            return (T)JSONObject.toBean((JSONObject)json, clazz);
        }
        return null;
    }

    public static JSONObject decrypt(WeappData weappData, String sessionKey) {
        try {
            AES aes = new AES();
            byte[] resultByte = aes.decrypt(Base64.decodeBase64((String)weappData.getEncryptedData()), Base64.decodeBase64((String)sessionKey), Base64.decodeBase64((String)weappData.getIv()));
            if (null != resultByte && resultByte.length > 0) {
                String str = new String(resultByte, "UTF-8");
                return JSONObject.fromObject((Object)str);
            }
        }
        catch (InvalidAlgorithmParameterException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static String sessionKey(String sessionId) {
        return SESSION_CACHE_KEY_PREFIX + sessionId;
    }
}

