package com.crawler.social.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;

/**
 * social配置
 * @author Rubekid
 *
 * 2017年3月31日 下午8:41:29
 */
public class SocialProperties {

	private static final Logger logger = LoggerFactory.getLogger(SocialProperties.class);
    private static Properties properties;

    static {
        try {
            String fileName = "social.properties";
            properties = new Properties();
            String userDir = System.getProperty("user.dir");
            String configPath = userDir + File.separator + "config" + File.separator + fileName;
            File configFile = new File(configPath);
            if(configFile.exists()){
                InputStream in = new BufferedInputStream(new FileInputStream(configFile));
                properties.load(in);
            }
            else{
                InputStream stream = SocialProperties.class.getClassLoader().getResourceAsStream(fileName);
                if (stream != null) {
                    properties.load(stream);
                }
                else{
                    logger.warn("Read social.properties error.");
                }
            }
        } catch (Exception ex) {
            logger.warn("Read social.properties error.", ex);
        }
    }
    
    public static Properties getProperties() {
        return properties;
    }



    public static String getProperty(String key) {
        return properties.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        return properties.getProperty(key, defaultValue);
    }

    public static void setProperty(String key, String value) {
        properties.setProperty(key, value);
    }

    public static int getPropertyForInteger(String key) {
        String value = getProperty(key);
        try {
            return Integer.parseInt(value);
        } catch (Exception ex) {
            throw new IllegalArgumentException("转换 \"" + value + "\" 为 int 过程发生错误，引发的 properties 属性为 " + key);
        }
    }

    public static int getPropertyForInteger(String key, String defaultValue) {
        String value = getProperty(key, defaultValue);
        try {
            return Integer.parseInt(value);
        } catch (Exception ex) {
            throw new IllegalArgumentException("转换 \"" + value + "\" 为 int 过程发生错误，引发的 properties 属性为 " + key);
        }
    }
    
    public static boolean getPropertyForBoolean(String key, String defaultValue) {
        String value = getProperty(key, defaultValue);
        try {
            return Boolean.parseBoolean(value);
        } catch (Exception ex) {
            throw new IllegalArgumentException("转换 \"" + value + "\" 为 boolean 过程发生错误，引发的 properties 属性为 " + key);
        }
    }
}