package com.crawler.social.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * Bean工具类
 * @author rubekid
 *
 * 2017年10月14日 下午8:00:37
 */
public class BeanUtils {
	
	private static final Logger LOGGER = LoggerFactory.getLogger(BeanUtils.class);

	/**
	 * 对象转换
	 * @param object
	 * @param clazz
	 * @param ignoreProperties
	 * @return
	 */
	public static <T> T transfer(Object object, Class<T> clazz){
		if(object == null){
			return null;
		}
		String json = JSONObject.toJSONString(object);
		return JSONObject.parseObject(json, clazz);
	}
	
	/**
	 * 转字符串
	 * @param object
	 * @return
	 */
	public static String toJSONString(Object object) {
		if(object != null){
			ObjectMapper objectMapper = new ObjectMapper();
			try {
				return objectMapper.writeValueAsString(object);
			} catch (JsonProcessingException ex) {
				LOGGER.error(ex.getMessage(), ex);
			}
		}
		return "";
	}
}
