package com.crawler.social.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

/**
 * 字符串工具
 * 
 * @author rubekid
 *
 */
public class StringUtils {

	private static final String CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
	
	private static int index = 0;
	
	/**
	 * 获取下标
	 * @return
	 */
	public synchronized static int getOffset(){
		index ++;
		index = index % 10000;
		return index;
	}

	/**
	 * 获取指定长度随机字符串
	 * 
	 * @param length
	 * @return
	 */
	public static String getRandomString(int length) {
		StringBuffer sb = new StringBuffer();
		Random random = new Random();
		int offset = getOffset();
		int len = CHARS.length();
		for (int i = 0; i < length; i++) {
			int index = random.nextInt(len) + offset;
			index = index % length;
			sb.append(CHARS.charAt(index));
		}
		return sb.toString();
	}

	/**
	 * 获取随机数字字符串
	 * 
	 * @param length
	 * @return
	 */
	public static String getRandomNumString(int length) {
		if (length <= 0) {
			return "";
		}

		char[] chars = ("0123456789").toCharArray();
		Random random = new Random();
		char[] randomStr = new char[length];
		int offset = getOffset();
		int len = chars.length;
		for (int i = 0; i < length; i++) {
			int index = random.nextInt(len) + offset;
			index = index % length;
			randomStr[i] = chars[index];
		}
		return String.valueOf(randomStr);

	}



	/**
	 * 判断字符串是否为空
	 * 
	 * @param string
	 * @return
	 */
	public static boolean isNullOrEmpty(String string) {
		return string == null || "".equals(string);
	}
	
	
	
	/**
	 * 生成订单号
	 * @return
	 */
	public static String uniqueNo(String prev){
		return prev + getDateString() + StringUtils.getRandomNumString(3);
	}
	
	/**
	 * 获取时间字符串
	 * @return
	 */
	public static String getDateString(){
		SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
		return format.format(new Date());
	}
	
	/**
	 * 生成唯一单号
	 * @return
	 */
	public static String uniqueId(){
		return uniqueNo("");
	}
}